/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.notification;

import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.refs.IntRef;

public class MultipleConditionVariablesStressTest {
    private int objectCount = 100;
    private int threadCount = 10;
    private Stm stm;
    private IntRef[] values;
    private volatile boolean stop;

    @Before
    public void setUp() {
        this.stop = false;
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.values = new IntRef[this.objectCount];
        for (int k = 0; k < this.objectCount; ++k) {
            this.values[k] = new IntRef(0);
        }
    }

    @Test
    public void test() {
        TestThread[] threads = this.createThreads();
        this.values[0].inc();
        TestUtils.startAll((TestThread[])threads);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])threads);
    }

    public WorkerThread[] createThreads() {
        WorkerThread[] threads = new WorkerThread[this.threadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new WorkerThread(k);
        }
        return threads;
    }

    class WorkerThread
    extends TestThread {
        public WorkerThread(int id) {
            super("WorkerThread-" + id);
        }

        public void doRun() {
            int count = 0;
            while (!MultipleConditionVariablesStressTest.this.stop) {
                this.doit();
                if (count % 10000 == 0) {
                    System.out.printf("%s is at count %s\n", this.getName(), count);
                }
                ++count;
            }
        }

        @TransactionalMethod(maxRetries=10000)
        public void doit() {
            for (IntRef value : MultipleConditionVariablesStressTest.this.values) {
                if (value.get() != 1) continue;
                value.dec();
                int random = TestUtils.randomInt((int)(MultipleConditionVariablesStressTest.this.values.length - 1));
                MultipleConditionVariablesStressTest.this.values[random].inc();
                return;
            }
            StmUtils.retry();
        }
    }
}

