/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.notification;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.NoRetryPossibleException;
import org.multiverse.integrationtests.Ref;

public class WhenReadTrackingDisabledRetryTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test(expected=NoRetryPossibleException.class)
    public void whenUsedUpdateTransaction() {
        Ref ref1 = new Ref();
        this.updateBlockingMethod(ref1);
        Assert.fail();
    }

    @Test(expected=NoRetryPossibleException.class)
    public void whenUnusedUpdateTransaction() {
        this.updateBlockingMethod(new Ref[0]);
        Assert.fail();
    }

    @TransactionalMethod(trackReads=false, readonly=false)
    public void updateBlockingMethod(Ref ... refs) {
        for (Ref ref : refs) {
            ref.get();
        }
        StmUtils.retry();
    }

    @Test(expected=NoRetryPossibleException.class)
    public void whenUnusedReadonlyTransaction() {
        this.readonlyBlockingMethod(new Ref[0]);
        Assert.fail();
    }

    @Test(expected=NoRetryPossibleException.class)
    public void whenUsedReadonlyTransaction() {
        Ref ref1 = new Ref();
        this.readonlyBlockingMethod(ref1);
        Assert.fail();
    }

    @TransactionalMethod(trackReads=false, readonly=true)
    public void readonlyBlockingMethod(Ref ... refs) {
        for (Ref ref : refs) {
            ref.get();
        }
        StmUtils.retry();
    }
}

