/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.integrationtests.Ref;

public class ReadonlyScopeTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void readonlySurroundingUpdate() {
        Ref ref = new Ref();
        try {
            this.readonlySurroundingUpdate(ref);
            Assert.fail();
        }
        catch (ReadonlyException readonlyException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)ref.get());
    }

    @TransactionalMethod(readonly=true)
    public void readonlySurroundingUpdate(Ref ref) {
        this.innerUpdate(ref);
    }

    public void innerUpdate(Ref ref) {
        ref.inc();
    }

    @Test
    public void updateSurroundingReadonly() {
        Ref ref = new Ref();
        this.outerUpdateInnerReadonly(ref);
        Assert.assertEquals((long)1L, (long)ref.get());
    }

    @TransactionalMethod(readonly=false)
    public void outerUpdateInnerReadonly(Ref ref) {
        this.innerReadonly(ref);
    }

    @TransactionalMethod(readonly=false)
    private void innerReadonly(Ref ref) {
        ref.inc();
    }
}

