/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.scalability;

import java.util.ArrayList;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.templates.TransactionTemplate;
import org.multiverse.transactional.refs.IntRef;

public class LargeNonParallelWriteonlyTransactionsPerformanceTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test_1() {
        this.test(1);
    }

    @Test
    public void test_10() {
        this.test(10);
    }

    @Test
    public void test_100() {
        this.test(100);
    }

    @Test
    public void test_1000() {
        this.test(1000);
    }

    @Test
    public void test_10000() {
        this.test(10000);
    }

    @Test
    public void test_100000() {
        this.test(100000);
    }

    @Test
    public void test_1000000() {
        this.test(1000000);
    }

    public void test_10000000() {
        this.test(10000000);
    }

    public void test(final int x) {
        final ArrayList list = new ArrayList(x);
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setReadonly(false).setFamilyName(this.getClass().getName() + ".test()").setSpeculativeConfigurationEnabled(true).setReadTrackingEnabled(false).build();
        new TransactionTemplate(txFactory){

            public Object execute(Transaction tx) {
                for (int k = 0; k < x; ++k) {
                    IntRef value = new IntRef(k);
                    list.add(value);
                }
                return null;
            }
        }.execute();
    }
}

