/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.stability;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.refs.IntRef;

public class ConflictingWritesDontBreakSystemStressTest {
    private IntRef[] refs;
    private volatile boolean stop;
    private int structureCount = 100;
    private int writerThreadCount = 10;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stop = false;
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        this.refs = new IntRef[this.structureCount];
        for (int k = 0; k < this.refs.length; ++k) {
            this.refs[k] = new IntRef(0);
        }
        TestThread[] threads = new WriterThread[this.writerThreadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new WriterThread(k);
        }
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])threads);
        this.assertValues(this.sum((WriterThread[])threads));
    }

    private void assertValues(int value) {
        for (IntRef ref : this.refs) {
            Assert.assertEquals((long)value, (long)ref.get());
        }
    }

    public int sum(WriterThread[] threads) {
        int value = 0;
        for (WriterThread t : threads) {
            value += t.writeCount;
        }
        return value;
    }

    private class WriterThread
    extends TestThread {
        private int writeCount;

        private WriterThread(int id) {
            super("WriterThread-" + id);
        }

        public void doRun() {
            while (!ConflictingWritesDontBreakSystemStressTest.this.stop) {
                this.doTransaction();
                if (this.writeCount % 10 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), this.writeCount);
                }
                ++this.writeCount;
            }
        }

        @TransactionalMethod
        public void doTransaction() {
            for (int k = 0; k < ConflictingWritesDontBreakSystemStressTest.this.refs.length; ++k) {
                IntRef ref = ConflictingWritesDontBreakSystemStressTest.this.refs[k];
                TestUtils.sleepRandomMs((int)1);
                ref.inc();
            }
        }
    }
}

