/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.stability;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;

public class TransactionRetriedOnFailureTest {
    private Stm stm;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stm = GlobalStmInstance.getGlobalStmInstance();
    }

    @Test
    public void whenReadConflict() {
        Ref ref = new Ref();
        DelayedReadThread t = new DelayedReadThread(ref);
        t.start();
        ref.set(100);
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
        Assert.assertEquals((long)1L, (long)t.readCount);
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @Test
    public void whenWriteConflict() {
        Ref ref = new Ref();
        DelayedWriteThread t = new DelayedWriteThread(ref, 200);
        t.start();
        ref.set(100);
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
        Assert.assertEquals((long)1L, (long)t.writeCount);
        Assert.assertEquals((long)200L, (long)ref.get());
    }

    @Test
    public void whenRetry() {
        Ref ref = new Ref(0);
        BlockingReadThread t = new BlockingReadThread(ref, 1);
        t.start();
        TestUtils.sleepMs((long)500L);
        ref.set(1);
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
        Assert.assertEquals((long)1L, (long)ref.get());
        Assert.assertEquals((long)1L, (long)t.retries);
    }

    @Test
    @Ignore
    public void whenSpeculativeFailure() {
    }

    @TransactionalObject
    static class Ref {
        private int value;

        public Ref() {
            this(0);
        }

        public Ref(int value) {
            this.value = value;
        }

        public int get() {
            return this.value;
        }

        public void set(int value) {
            this.value = value;
        }
    }

    private static class DelayedWriteThread
    extends TestThread {
        private final Ref ref;
        private int startedCount = 0;
        private int writeCount;
        private int update;

        public DelayedWriteThread(Ref ref, int update) {
            this.ref = ref;
            this.update = update;
        }

        @TransactionalMethod(readonly=false)
        public void doRun() throws Exception {
            ++this.startedCount;
            TestUtils.sleepMs((long)500L);
            this.ref.set(this.update);
            ++this.writeCount;
        }
    }

    private static class DelayedReadThread
    extends TestThread {
        private final Ref ref;
        private int startedCount = 0;
        private int read;
        private int readCount;

        public DelayedReadThread(Ref ref) {
            super("DelayedReadThread");
            this.ref = ref;
        }

        @TransactionalMethod(readonly=false)
        public void doRun() throws Exception {
            ++this.startedCount;
            TestUtils.sleepMs((long)500L);
            this.read = this.ref.get();
            ++this.readCount;
        }
    }

    private static class BlockingReadThread
    extends TestThread {
        private final Ref ref;
        private final int expectedValue;
        private int startedCount;
        private int retries;

        public BlockingReadThread(Ref ref, int expectedValue) {
            this.ref = ref;
            this.expectedValue = expectedValue;
        }

        @TransactionalMethod(readonly=true, trackReads=true)
        public void doRun() throws Exception {
            ++this.startedCount;
            if (this.ref.get() != this.expectedValue) {
                ++this.retries;
                StmUtils.retry();
            }
        }
    }
}

