/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;

public class AlphaTranlocal_hasConflictTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @Test
    public void whenFreshAndNoConflictingTransaction_thenNoConflict() {
        ManualRef ref = ManualRef.createUncommitted();
        ManualRefTranlocal tranlocal = new ManualRefTranlocal(ref);
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        boolean hasConflict = tranlocal.hasReadConflict(tx);
        Assert.assertFalse((boolean)hasConflict);
    }

    @Test
    public void whenUpdatedAndNoConflictingTransaction_thenNoConflict() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        ManualRefTranlocal tranlocal = new ManualRefTranlocal(committed);
        Assert.assertFalse((boolean)tranlocal.hasWriteConflict());
    }

    @Test
    public void whenUpdatedAndConflictingTransaction_thenConflict() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        ref.inc(this.stm);
        ManualRefTranlocal tranlocal = new ManualRefTranlocal(committed);
        Assert.assertTrue((boolean)tranlocal.hasWriteConflict());
    }

    @Test
    public void whenReadonlyAndNoConflictTransaction_thenNoConflict() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal readonly = (ManualRefTranlocal)ref.___load();
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        boolean hasConflict = readonly.hasReadConflict(tx);
        Assert.assertFalse((boolean)hasConflict);
    }

    @Test
    public void whenReadonlyAndConflictingTransaction_thenConflict() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal readonly = (ManualRefTranlocal)ref.___load();
        ref.inc(this.stm);
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        boolean hasConflict = readonly.hasReadConflict(tx);
        Assert.assertTrue((boolean)hasConflict);
    }
}

