/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha;

import java.util.LinkedList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.annotations.NonTransactional;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.transactions.readonly.ArrayReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.MapReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.MonoReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.NonTrackingReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.ArrayUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MapUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MonoUpdateAlphaTransaction;
import org.multiverse.transactional.arrays.TransactionalReferenceArray;

public class SpeculativeSizeTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenReadTracking() {
        SpeculativeSize o = new SpeculativeSize();
        o.trackingRead();
        Assert.assertEquals((long)3L, (long)o.transactions.size());
        TestUtils.assertInstanceOf(o.transactions.get(0), MonoReadonlyAlphaTransaction.class);
        TestUtils.assertInstanceOf(o.transactions.get(1), ArrayReadonlyAlphaTransaction.class);
        TestUtils.assertInstanceOf(o.transactions.get(2), MapReadonlyAlphaTransaction.class);
        SpeculativeSize o2 = new SpeculativeSize();
        o2.trackingRead();
        Assert.assertEquals((long)1L, (long)o2.transactions.size());
        TestUtils.assertInstanceOf(o2.transactions.get(0), MapReadonlyAlphaTransaction.class);
    }

    @Test
    public void whenSpeculativeSizeAndNonTrackingRead() {
        SpeculativeSize o = new SpeculativeSize();
        o.read();
        Assert.assertEquals((long)1L, (long)o.transactions.size());
        TestUtils.assertInstanceOf(o.transactions.get(0), NonTrackingReadonlyAlphaTransaction.class);
        SpeculativeSize o2 = new SpeculativeSize();
        o2.read();
        Assert.assertEquals((long)1L, (long)o2.transactions.size());
        TestUtils.assertInstanceOf(o2.transactions.get(0), NonTrackingReadonlyAlphaTransaction.class);
    }

    @Test
    public void whenSpeculativeSizeAndUpdateFailure_thenUpgradedToMap() {
        SpeculativeSize o = new SpeculativeSize();
        o.update();
        Assert.assertEquals((String)("" + o.transactions), (long)4L, (long)o.transactions.size());
        TestUtils.assertInstanceOf(o.transactions.get(0), NonTrackingReadonlyAlphaTransaction.class);
        TestUtils.assertInstanceOf(o.transactions.get(1), MonoUpdateAlphaTransaction.class);
        TestUtils.assertInstanceOf(o.transactions.get(2), ArrayUpdateAlphaTransaction.class);
        TestUtils.assertInstanceOf(o.transactions.get(3), MapUpdateAlphaTransaction.class);
        SpeculativeSize o2 = new SpeculativeSize();
        o2.update();
        Assert.assertEquals((long)1L, (long)o2.transactions.size());
        TestUtils.assertInstanceOf(o2.transactions.get(0), MapUpdateAlphaTransaction.class);
    }

    @TransactionalObject
    class SpeculativeSize {
        private TransactionalReferenceArray<String> array = new TransactionalReferenceArray(1000);
        @NonTransactional
        private List<Transaction> transactions = new LinkedList<Transaction>();

        SpeculativeSize() {
        }

        public void read() {
            this.transactions.add(ThreadLocalTransaction.getThreadLocalTransaction());
            for (int k = 0; k < this.array.length(); ++k) {
                this.array.get(k);
            }
        }

        @TransactionalMethod(trackReads=true)
        public void trackingRead() {
            this.transactions.add(ThreadLocalTransaction.getThreadLocalTransaction());
            for (int k = 0; k < this.array.length(); ++k) {
                this.array.get(k);
            }
        }

        public void update() {
            this.transactions.add(ThreadLocalTransaction.getThreadLocalTransaction());
            for (int k = 0; k < this.array.length(); ++k) {
                this.array.set(k, (Object)((String)this.array.get(k) + "a"));
            }
        }
    }
}

