/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.transactions.readonly.AbstractReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.NonTrackingReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.AbstractUpdateAlphaTransaction;

public class TransactionSelectionTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        SomeAtomicObject object = new SomeAtomicObject();
        object.noAnnotations();
        object.readOnly();
        object.readOnlyAndTrackReads();
        object.updateTracking();
        object.updateNonTracking();
    }

    @TransactionalObject
    public class SomeAtomicObject {
        private int somefield = 1;

        public void noAnnotations() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertTrue((boolean)(tx instanceof NonTrackingReadonlyAlphaTransaction));
        }

        @TransactionalMethod(readonly=true)
        public void readOnly() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertTrue((boolean)(tx instanceof AbstractReadonlyAlphaTransaction));
        }

        @TransactionalMethod(readonly=true, trackReads=true)
        public void readOnlyAndTrackReads() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertTrue((boolean)(tx instanceof AbstractReadonlyAlphaTransaction));
        }

        @TransactionalMethod(readonly=false, trackReads=true)
        public void updateTracking() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertFalse((boolean)tx.getConfiguration().isReadonly());
            Assert.assertTrue((boolean)tx.getConfiguration().isReadTrackingEnabled());
            Assert.assertTrue((boolean)(tx instanceof AbstractUpdateAlphaTransaction));
        }

        @TransactionalMethod(trackReads=false)
        public void updateNonTracking() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertTrue((boolean)(tx instanceof NonTrackingReadonlyAlphaTransaction));
        }
    }
}

