/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.stms.alpha.AlphaStm;

public class NonStaticInnerClassThatIsNotTransactionalObjectTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @Test
    public void testAnonymousInnerClass() {
        AnonymousInnerClass o = new AnonymousInnerClass();
        Assert.assertNotNull((Object)o.getRunnable());
    }

    @Test
    public void testNamedInnerClass() {
        NamedInnerClass o = new NamedInnerClass();
        Assert.assertNotNull((Object)o.getNamedRunnable());
    }

    @TransactionalObject
    public static class NamedInnerClass {
        private NamedRunnable someRunnable = new NamedRunnable();

        public NamedRunnable getNamedRunnable() {
            return this.someRunnable;
        }

        class NamedRunnable
        implements Runnable {
            NamedRunnable() {
            }

            @Override
            public void run() {
            }
        }
    }

    @TransactionalObject
    public static class AnonymousInnerClass {
        private Runnable runnable = new Runnable(){

            @Override
            public void run() {
            }
        };

        public Runnable getRunnable() {
            return this.runnable;
        }
    }
}

