/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.ThreadLocalTransaction;

public class TransactionalObject_InstanceFieldGetSetTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void simplePutAndGet() {
        PutOnField putOnField = new PutOnField();
        putOnField.doIt();
        Assert.assertEquals((long)1L, (long)putOnField.getValue());
    }

    @Test
    public void putAndGetOnReferencedNonTxObject() {
        NonTxObject nonTxObject = new NonTxObject();
        PutGetOnNonTxObject o = new PutGetOnNonTxObject(nonTxObject);
        o.doIt();
        Assert.assertEquals((long)10L, (long)o.getValue());
    }

    @Test
    public void putAndGetOnReferencedAtomicObject() {
        SomeTxObject nonTxObject = new SomeTxObject();
        PutGetOnTxObject o = new PutGetOnTxObject(nonTxObject);
        o.doIt();
        Assert.assertEquals((long)10L, (long)o.getValue());
    }

    @TransactionalObject
    public static class PutGetOnTxObject {
        SomeTxObject value = new SomeTxObject();

        public PutGetOnTxObject(SomeTxObject value) {
        }

        public void doIt() {
            this.value.v = 10;
        }

        public int getValue() {
            return this.value.v;
        }
    }

    static class SomeTxObject {
        int v;

        SomeTxObject() {
        }
    }

    @TransactionalObject
    public static class PutGetOnNonTxObject {
        NonTxObject value = new NonTxObject();

        public PutGetOnNonTxObject(NonTxObject value) {
        }

        public void doIt() {
            this.value.v = 10;
        }

        public int getValue() {
            return this.value.v;
        }
    }

    static class NonTxObject {
        int v;

        NonTxObject() {
        }
    }

    @TransactionalObject
    public static class PutOnField {
        int value = 0;

        public void doIt() {
            ++this.value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

