/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.integrationtest.languageconstructs;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;
import org.multiverse.transactional.collections.TransactionalList;
import org.multiverse.transactional.refs.IntRef;

public class ForLoopTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenUsedInExpression() {
        int result = this.usedInExpression();
        Assert.assertEquals((long)10L, (long)result);
    }

    @TransactionalMethod
    public int usedInExpression() {
        int result = 0;
        IntRef ref = new IntRef();
        while (ref.get() < 10) {
            ++result;
            ref.inc();
        }
        return result;
    }

    @Test
    public void whenUsedInsideLoop() {
        IntRef ref = new IntRef();
        this.usedInLoop(ref);
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @TransactionalMethod
    public void usedInLoop(IntRef ref) {
        for (int k = 0; k < 10; ++k) {
            ref.inc();
        }
    }

    @Test
    public void whenUsedInNewForLoop() {
        TransactionalArrayList list = new TransactionalArrayList((Object[])new String[]{"a", "b", "c"});
        String result = this.newForLoop((TransactionalList<String>)list);
        Assert.assertEquals((Object)"abc", (Object)result);
    }

    @TransactionalMethod
    public String newForLoop(TransactionalList<String> list) {
        String result = "";
        for (String item : list) {
            result = result + item;
        }
        return result;
    }
}

