/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.integrationtest.languageconstructs;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.manualinstrumentation.IntRef;

public class IfElseTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenUsedInExpression() {
        Assert.assertEquals((long)1L, (long)this.methodWhereUsedInCondition(new IntRef(0)));
        Assert.assertEquals((long)2L, (long)this.methodWhereUsedInCondition(new IntRef(1)));
    }

    @TransactionalMethod
    public int methodWhereUsedInCondition(IntRef ref) {
        if (ref.get() == 0) {
            return 1;
        }
        return 2;
    }

    @Test
    public void whenUsedInIfBranch() {
        IntRef ref = new IntRef();
        this.methodWhereUsedInBranch(true, ref);
        Assert.assertEquals((long)1L, (long)ref.get());
    }

    @Test
    public void whenUsedInElseBranch() {
        IntRef ref = new IntRef();
        this.methodWhereUsedInBranch(false, ref);
        Assert.assertEquals((long)2L, (long)ref.get());
    }

    @TransactionalMethod
    public void methodWhereUsedInBranch(boolean condition, IntRef ref) {
        if (condition) {
            ref.set(1);
        } else {
            ref.set(2);
        }
    }
}

