/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.transactionalmethod;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.instrumentation.InstrumentationTestUtils;
import org.multiverse.stms.alpha.AlphaStm;

public class TransactionalMethod_AccessModifierTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        InstrumentationTestUtils.resetInstrumentationProblemMonitor();
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        InstrumentationTestUtils.resetInstrumentationProblemMonitor();
    }

    public static void assertTransactionWorking() {
        TestUtils.assertIsAlive((Transaction[])new Transaction[]{ThreadLocalTransaction.getThreadLocalTransaction()});
    }

    @Test
    public void privateMethod() {
        PrivateMethod method = new PrivateMethod();
        method.doIt();
    }

    @Test
    public void publicMethod() {
        PublicMethod method = new PublicMethod();
        method.doIt();
    }

    @Test
    public void protectedMethod() {
        ProtectedMethod method = new ProtectedMethod();
        method.doIt();
    }

    @Test
    public void packageFriendlyMethod() {
        PackageFriendlyMethod method = new PackageFriendlyMethod();
        method.doIt();
    }

    @Test
    public void synchronizedMethodGivesNoProblems() {
        SynchronizedMethod method = new SynchronizedMethod();
        method.doIt();
    }

    public class SynchronizedMethod {
        @TransactionalMethod
        public synchronized void doIt() {
            TransactionalMethod_AccessModifierTest.assertTransactionWorking();
        }
    }

    public static class PackageFriendlyMethod {
        @TransactionalMethod
        void doIt() {
            TransactionalMethod_AccessModifierTest.assertTransactionWorking();
        }
    }

    public static class ProtectedMethod {
        @TransactionalMethod
        protected void doIt() {
            TransactionalMethod_AccessModifierTest.assertTransactionWorking();
        }
    }

    public static class PublicMethod {
        @TransactionalMethod
        public void doIt() {
            TransactionalMethod_AccessModifierTest.assertTransactionWorking();
        }
    }

    public static class PrivateMethod {
        @TransactionalMethod
        private void doIt() {
            TransactionalMethod_AccessModifierTest.assertTransactionWorking();
        }
    }
}

