/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.integrationtests;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.refs.IntRef;

public class AtomicBehaviorStressTest {
    private IntRef ref;
    private volatile boolean stop;

    @Before
    public void setUp() {
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        this.ref = new IntRef(0);
        this.stop = true;
    }

    @Test
    public void test() {
        ModifyThread modifyThread = new ModifyThread(0);
        ObserverThread observerThread = new ObserverThread();
        TestUtils.startAll((TestThread[])new TestThread[]{modifyThread, observerThread});
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)20000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])new TestThread[]{modifyThread, observerThread});
    }

    class ObserverThread
    extends TestThread {
        public ObserverThread() {
            super("ObserverThread");
        }

        public void doRun() {
            while (!AtomicBehaviorStressTest.this.stop) {
                this.doit();
                TestUtils.sleepRandomMs((int)5);
            }
        }

        @TransactionalMethod
        public void doit() {
            if (AtomicBehaviorStressTest.this.ref.get() % 2 != 0) {
                Assert.fail();
            }
        }
    }

    class ModifyThread
    extends TestThread {
        public ModifyThread(int id) {
            super("ModifyThread-" + id);
        }

        public void doRun() {
            while (!AtomicBehaviorStressTest.this.stop) {
                try {
                    this.doit();
                }
                catch (DeadTransactionException deadTransactionException) {}
            }
        }

        @TransactionalMethod
        public void doit() {
            if (AtomicBehaviorStressTest.this.ref.get() % 2 != 0) {
                Assert.fail();
            }
            AtomicBehaviorStressTest.this.ref.inc();
            TestUtils.sleepRandomMs((int)20);
            if (TestUtils.randomBoolean()) {
                ThreadLocalTransaction.getThreadLocalTransaction().abort();
            } else {
                AtomicBehaviorStressTest.this.ref.inc();
            }
        }
    }
}

