/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.integrationtests;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.transactional.refs.BasicRef;

public class ReadonlyTransactionTest {
    private static AlphaStm stm;

    @Before
    public void setUp() {
        stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void refIsTransformed() {
        BasicRef ref = new BasicRef();
        Assert.assertTrue((boolean)(ref instanceof AlphaTransactionalObject));
    }

    @Test
    public void whenNonTrackingRead_thenReadonlyOperationSucceeds() {
        BasicRef ref = new BasicRef((Object)10);
        long version = stm.getVersion();
        ReadonlyTransactionTest.executeNonTrackingReadonlyMethod((BasicRef<Integer>)ref, 10);
        Assert.assertEquals((long)version, (long)stm.getVersion());
    }

    @TransactionalMethod(readonly=true)
    public static void executeNonTrackingReadonlyMethod(BasicRef<Integer> ref, int expectedValue) {
        Assert.assertEquals((long)expectedValue, (long)((Integer)ref.get()).intValue());
    }

    @Test
    public void whenTrackingRead_thenReadonlyOperationSucceeds() {
        BasicRef ref = new BasicRef((Object)10);
        long version = stm.getVersion();
        ReadonlyTransactionTest.executeTrackingReadonlyMethod((BasicRef<Integer>)ref, 10);
        Assert.assertEquals((long)version, (long)stm.getVersion());
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public static void executeTrackingReadonlyMethod(BasicRef<Integer> ref, int expectedValue) {
        int found = (Integer)ref.get();
        Assert.assertEquals((long)expectedValue, (long)found);
    }

    @Test
    public void whenNonTrackingReadonly_thenModificationInReadonlyTransactionIsDetected() {
        BasicRef ref = new BasicRef((Object)0);
        long version = stm.getVersion();
        try {
            ReadonlyTransactionTest.nonTrackingReadonlyMethodThatUpdates((BasicRef<Integer>)ref);
            Assert.fail();
        }
        catch (ReadonlyException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)stm.getVersion());
        Assert.assertEquals((long)0L, (long)((Integer)ref.get()).intValue());
    }

    @TransactionalMethod(readonly=true, trackReads=false)
    public static void nonTrackingReadonlyMethodThatUpdates(BasicRef<Integer> ref) {
        ref.set((Object)1);
    }

    @Test
    public void whenTrackingReadonly_thenModificationInReadonlyTransactionIsDetected() {
        BasicRef ref = new BasicRef((Object)0);
        long version = stm.getVersion();
        try {
            ReadonlyTransactionTest.trackingReadonlyMethodThatUpdates((BasicRef<Integer>)ref);
            Assert.fail();
        }
        catch (ReadonlyException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)stm.getVersion());
        Assert.assertEquals((long)0L, (long)((Integer)ref.get()).intValue());
    }

    @TransactionalMethod(readonly=true, trackReads=false)
    public static void trackingReadonlyMethodThatUpdates(BasicRef<Integer> ref) {
        ref.set((Object)1);
    }

    public static AlphaTranlocal getTranlocal(Object atomicObject) {
        AlphaTransaction t = (AlphaTransaction)ThreadLocalTransaction.getThreadLocalTransaction();
        return t.openForRead((AlphaTransactionalObject)atomicObject);
    }
}

