/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.manualinstrumentation;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.manualinstrumentation.AbaRef;

public class AbaRefTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    public Transaction startTransaction() {
        Transaction t = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        return t;
    }

    @Test
    public void testAbaProblemIsDetected() {
        String a = "A";
        String b = "B";
        AbaRef<String> ref = new AbaRef<String>("A");
        long startVersion = this.stm.getVersion();
        Transaction t = this.startTransaction();
        ref.set("B");
        ref.set("A");
        t.commit();
        Assert.assertEquals((long)(startVersion + 1L), (long)this.stm.getVersion());
    }
}

