/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.manualinstrumentation;

import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.StmUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.stms.alpha.manualinstrumentation.IntStack;
import org.multiverse.templates.TransactionTemplate;

public final class IntQueue {
    private final IntStack pushedStack;
    private final IntStack readyToPopStack;
    private final int maxCapacity;
    private static final TransactionFactory sizeTxFactory = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setReadonly(true).setReadTrackingEnabled(false).build();
    private static final TransactionFactory isEmptyTxFactory = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setReadonly(true).setReadTrackingEnabled(false).build();

    public IntQueue() {
        this(Integer.MAX_VALUE);
    }

    public IntQueue(int maxCapacity) {
        if (maxCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.pushedStack = new IntStack();
        this.readyToPopStack = new IntStack();
        this.maxCapacity = maxCapacity;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void push(final int item) {
        new TransactionTemplate(){

            public Object execute(Transaction t) {
                if (IntQueue.this.size() >= IntQueue.this.maxCapacity) {
                    StmUtils.retry();
                }
                IntQueue.this.pushedStack.push(item);
                return null;
            }
        }.execute();
    }

    public int pop() {
        return (Integer)new TransactionTemplate<Integer>(){

            public Integer execute(Transaction t) {
                if (IntQueue.this.readyToPopStack.isEmpty()) {
                    while (!IntQueue.this.pushedStack.isEmpty()) {
                        IntQueue.this.readyToPopStack.push(IntQueue.this.pushedStack.pop());
                    }
                }
                return IntQueue.this.readyToPopStack.pop();
            }
        }.execute();
    }

    public int size() {
        return (Integer)new TransactionTemplate<Integer>(sizeTxFactory){

            public Integer execute(Transaction t) {
                return IntQueue.this.pushedStack.size() + IntQueue.this.readyToPopStack.size();
            }
        }.execute();
    }

    public boolean isEmpty() {
        return (Boolean)new TransactionTemplate<Boolean>(isEmptyTxFactory){

            public Boolean execute(Transaction t) {
                return IntQueue.this.pushedStack.isEmpty() && IntQueue.this.readyToPopStack.isEmpty();
            }
        }.execute();
    }
}

