/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.manualinstrumentation;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;

public class ManualRefTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = AlphaStm.createFast();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void testConstruction() {
        long version = this.stm.getVersion();
        ManualRef ref = new ManualRef(this.stm, 10);
        Assert.assertEquals((long)10L, (long)ref.get(this.stm));
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ThreadLocalTransaction.getThreadLocalTransaction());
    }

    @Test
    public void testUpdate() {
        ManualRef ref = new ManualRef(this.stm, 10);
        long version = this.stm.getVersion();
        ref.inc(this.stm);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)11L, (long)ref.get(this.stm));
        Assert.assertNull((Object)ThreadLocalTransaction.getThreadLocalTransaction());
    }
}

