/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.manualinstrumentation;

import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.StmUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTranlocalSnapshot;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.mixins.BasicMixin;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.templates.TransactionTemplate;

public final class Stack<E>
extends BasicMixin {
    private static final TransactionFactory sizeTxFactory = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setReadonly(true).setReadTrackingEnabled(false).build();
    private static final TransactionFactory isEmptyTxFactory = GlobalStmInstance.getGlobalStmInstance().getTransactionFactoryBuilder().setReadonly(true).setReadTrackingEnabled(false).build();

    public Stack() {
        new TransactionTemplate(){

            public Object execute(Transaction t) {
                StackTranlocal tranlocal = (StackTranlocal)((AlphaTransaction)t).openForConstruction((AlphaTransactionalObject)Stack.this);
                return null;
            }
        }.execute();
    }

    public int size() {
        return (Integer)new TransactionTemplate<Integer>(sizeTxFactory){

            public Integer execute(Transaction transaction) {
                AlphaTransaction t = (AlphaTransaction)transaction;
                StackTranlocal tranlocal = (StackTranlocal)t.openForRead((AlphaTransactionalObject)Stack.this);
                return Stack.this.size(tranlocal);
            }
        }.execute();
    }

    public boolean isEmpty() {
        return (Boolean)new TransactionTemplate<Boolean>(isEmptyTxFactory){

            public Boolean execute(Transaction transaction) {
                AlphaTransaction t = (AlphaTransaction)transaction;
                StackTranlocal tranlocal = (StackTranlocal)t.openForRead((AlphaTransactionalObject)Stack.this);
                return Stack.this.isEmpty(tranlocal);
            }
        }.execute();
    }

    public void push(final E item) {
        new TransactionTemplate(){

            public Integer execute(Transaction t) {
                StackTranlocal tranlocal = (StackTranlocal)((AlphaTransaction)t).openForWrite((AlphaTransactionalObject)Stack.this);
                Stack.this.push(tranlocal, item);
                return null;
            }
        }.execute();
    }

    public E pop() {
        return (E)new TransactionTemplate<E>(){

            public E execute(Transaction t) {
                StackTranlocal tranlocal = (StackTranlocal)((AlphaTransaction)t).openForWrite((AlphaTransactionalObject)Stack.this);
                return Stack.this.pop(tranlocal);
            }
        }.execute();
    }

    public void clear() {
        new TransactionTemplate(){

            public Integer execute(Transaction t) {
                StackTranlocal tranlocal = (StackTranlocal)((AlphaTransaction)t).openForWrite((AlphaTransactionalObject)Stack.this);
                Stack.this.clear(tranlocal);
                return null;
            }
        }.execute();
    }

    public AlphaTranlocal ___openUnconstructed() {
        return new StackTranlocal(this);
    }

    public void clear(StackTranlocal<E> tranlocal) {
        if (tranlocal.isCommitted()) {
            throw new ReadonlyException();
        }
        tranlocal.size = 0;
        tranlocal.head = null;
    }

    public void push(StackTranlocal<E> tranlocal, E item) {
        if (tranlocal.isCommitted()) {
            throw new ReadonlyException();
        }
        if (item == null) {
            throw new NullPointerException();
        }
        tranlocal.head = new Node(tranlocal.head, item);
        ++tranlocal.size;
    }

    public E pop(StackTranlocal<E> tranlocal) {
        if (tranlocal.isCommitted()) {
            throw new ReadonlyException();
        }
        if (tranlocal.size == 0) {
            StmUtils.retry();
        }
        --tranlocal.size;
        Node oldHead = tranlocal.head;
        tranlocal.head = oldHead.next;
        return oldHead.value;
    }

    public boolean isEmpty(StackTranlocal<E> tranlocal) {
        return tranlocal.size == 0;
    }

    public int size(StackTranlocal<E> tranlocal) {
        return tranlocal.size;
    }

    public static final class StackTranlocal<E>
    extends AlphaTranlocal {
        int size;
        Node<E> head;

        StackTranlocal(Stack<E> txObject) {
            this.___transactionalObject = txObject;
        }

        StackTranlocal(StackTranlocal<E> origin) {
            this.___origin = origin;
            this.___transactionalObject = origin.___transactionalObject;
            this.size = origin.size;
            this.head = origin.head;
        }

        public AlphaTranlocal openForWrite() {
            return new StackTranlocal<E>(this);
        }

        public AlphaTranlocalSnapshot takeSnapshot() {
            throw new RuntimeException();
        }

        public boolean isDirty() {
            if (this.isCommitted()) {
                return false;
            }
            if (this.___origin == null) {
                return true;
            }
            StackTranlocal origin = (StackTranlocal)this.___origin;
            return origin.head != this.head;
        }
    }

    public static class Node<E> {
        final Node<E> next;
        final E value;

        Node(Node<E> next, E value) {
            this.next = next;
            this.value = value;
        }
    }
}

