/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.programmatic.ProgrammaticLongRef;
import org.multiverse.api.programmatic.ProgrammaticRef;
import org.multiverse.api.programmatic.ProgrammaticRefFactory;

public class AlphaProgrammaticLongRefAndRef_integrationStressTest {
    private int threadCount = 10;
    private volatile boolean stop;
    private int queueCapacity = 1000;
    private static final ProgrammaticRefFactory refFactory = GlobalStmInstance.getGlobalStmInstance().getProgrammaticRefFactoryBuilder().build();
    private Queue<String> queue;
    private static final String POISON = "poison";

    @Before
    public void setUp() {
        this.stop = false;
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.queue = new Queue();
    }

    @Before
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        TestThread[] producers = new ProducerThread[this.threadCount];
        TestThread[] consumers = new ConsumerThread[this.threadCount];
        for (int k = 0; k < this.threadCount; ++k) {
            producers[k] = new ProducerThread(k);
            consumers[k] = new ConsumerThread(k);
        }
        TestUtils.startAll((TestThread[])producers);
        TestUtils.startAll((TestThread[])consumers);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])producers);
        TestUtils.joinAll((TestThread[])consumers);
    }

    @TransactionalObject
    public class Stack<E> {
        final ProgrammaticRef<Node<E>> head = AlphaProgrammaticLongRefAndRef_integrationStressTest.access$300().atomicCreateRef(null);

        public boolean isEmpty() {
            return this.head.isNull();
        }

        void push(E item) {
            if (item == null) {
                throw new NullPointerException();
            }
            this.head.set(new Node<E>(item, (Node)this.head.get()));
        }

        E pop() {
            if (this.head.isNull()) {
                StmUtils.retry();
            }
            Node h = (Node)this.head.get();
            this.head.set(h.next);
            return h.value;
        }

        class Node<E> {
            final E value;
            final Node<E> next;

            Node(E value, Node<E> next) {
                this.value = value;
                this.next = next;
            }
        }
    }

    @TransactionalObject
    public class Queue<E> {
        private final Stack<E> queuedStack;
        private final Stack<E> popableStack;
        private final ProgrammaticLongRef size;

        public Queue() {
            this.queuedStack = new Stack();
            this.popableStack = new Stack();
            this.size = refFactory.atomicCreateLongRef(0L);
        }

        public void push(E item) {
            if (this.size() > AlphaProgrammaticLongRefAndRef_integrationStressTest.this.queueCapacity) {
                StmUtils.retry();
            }
            this.size.inc(1L);
            this.queuedStack.push(item);
        }

        public E pop() {
            if (this.queuedStack.head.isNull() && this.popableStack.head.isNull()) {
                StmUtils.retry();
            }
            this.size.inc(-1L);
            if (!this.popableStack.isEmpty()) {
                return this.popableStack.pop();
            }
            while (!this.queuedStack.isEmpty()) {
                this.popableStack.push(this.queuedStack.pop());
            }
            return this.popableStack.pop();
        }

        public int size() {
            return (int)this.size.get();
        }
    }

    public class ConsumerThread
    extends TestThread {
        private long consumeCount;

        public ConsumerThread(int id) {
            super("ConsumerThread-" + id);
        }

        public void doRun() throws Exception {
            boolean again;
            do {
                if (again = this.consume()) {
                    ++this.consumeCount;
                }
                if (this.consumeCount % 500000L != 0L) continue;
                System.out.printf("%s is at %s\n", this.getName(), this.consumeCount);
            } while (again);
        }

        @TransactionalMethod(trackReads=true)
        private boolean consume() {
            String item = (String)AlphaProgrammaticLongRefAndRef_integrationStressTest.this.queue.pop();
            return !AlphaProgrammaticLongRefAndRef_integrationStressTest.POISON.equals(item);
        }
    }

    public class ProducerThread
    extends TestThread {
        private long produceCount;

        public ProducerThread(int id) {
            super("ProducerThread-" + id);
        }

        public void doRun() throws Exception {
            while (!AlphaProgrammaticLongRefAndRef_integrationStressTest.this.stop) {
                this.produce();
                ++this.produceCount;
                if (this.produceCount % 100000L != 0L) continue;
                System.out.printf("%s is at %s\n", this.getName(), this.produceCount);
            }
            for (int k = 0; k < AlphaProgrammaticLongRefAndRef_integrationStressTest.this.threadCount; ++k) {
                AlphaProgrammaticLongRefAndRef_integrationStressTest.this.queue.push(AlphaProgrammaticLongRefAndRef_integrationStressTest.POISON);
            }
        }

        @TransactionalMethod(trackReads=true)
        private void produce() {
            AlphaProgrammaticLongRefAndRef_integrationStressTest.this.queue.push("foo");
        }
    }
}

