/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.programmatic.ProgrammaticRefFactory;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRef;
import org.multiverse.utils.ThreadLocalRandom;

public class AlphaProgrammaticLongRef_atomicStressTest {
    private volatile boolean stop;
    private AlphaStm stm;
    private AlphaProgrammaticLongRef[] refs;
    private int refCount = 1000;
    private int threadCount = 2;
    private ProgrammaticRefFactory refFactory;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        this.refFactory = this.stm.getProgrammaticRefFactoryBuilder().build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stop = false;
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        this.refs = this.createRefs();
        TestThread[] threads = this.createThreads();
        long startNs = System.nanoTime();
        TestUtils.startAll((TestThread[])threads);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])threads);
        long totalIncCount = this.sum((AtomicIncThread[])threads);
        Assert.assertEquals((long)totalIncCount, (long)this.sumRefs());
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)totalIncCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", TestUtils.format((double)transactionsPerSecond));
    }

    private long sumRefs() {
        long result = 0L;
        for (AlphaProgrammaticLongRef ref : this.refs) {
            result += ref.get();
        }
        return result;
    }

    private long sum(AtomicIncThread[] threads) {
        long result = 0L;
        for (AtomicIncThread t : threads) {
            result += t.count;
        }
        return result;
    }

    private AlphaProgrammaticLongRef[] createRefs() {
        AlphaProgrammaticLongRef[] refs = new AlphaProgrammaticLongRef[this.refCount];
        for (int k = 0; k < this.refCount; ++k) {
            refs[k] = (AlphaProgrammaticLongRef)this.refFactory.atomicCreateLongRef(0L);
        }
        return refs;
    }

    private AtomicIncThread[] createThreads() {
        AtomicIncThread[] threads = new AtomicIncThread[this.threadCount];
        for (int k = 0; k < this.threadCount; ++k) {
            threads[k] = new AtomicIncThread(k + 1);
        }
        return threads;
    }

    public class AtomicIncThread
    extends TestThread {
        private long count;

        public AtomicIncThread(int id) {
            super("AtomicIncThread-" + id);
        }

        public void doRun() throws Exception {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            while (!AlphaProgrammaticLongRef_atomicStressTest.this.stop) {
                int refIndex = Math.abs(Math.abs(random.nextInt()) % AlphaProgrammaticLongRef_atomicStressTest.this.refs.length);
                if (refIndex < 0) {
                    System.out.println("refIndex: " + refIndex);
                }
                AlphaProgrammaticLongRef_atomicStressTest.this.refs[refIndex].atomicInc(1L);
                if (this.count % 10000000L == 0L) {
                    System.out.printf("%s is at %s\n", this.getName(), this.count);
                }
                ++this.count;
            }
        }
    }
}

