/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.programmatic.ProgrammaticRefFactory;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRef;

public class AlphaProgrammaticLongRef_atomicWithoutStateSharedButSharedStmStressTest {
    private AlphaStm stm;
    private AlphaProgrammaticLongRef[] refs;
    private int threadCount = 8;
    private long incCountPerThread = 20000000L;
    private ProgrammaticRefFactory refFactory;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        this.refFactory = this.stm.getProgrammaticRefFactoryBuilder().build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        this.refs = this.createRefs();
        TestThread[] threads = this.createThreads();
        long startNs = System.nanoTime();
        TestUtils.startAll((TestThread[])threads);
        TestUtils.joinAll((TestThread[])threads);
        long totalIncCount = (long)this.threadCount * this.incCountPerThread;
        Assert.assertEquals((long)totalIncCount, (long)this.sum());
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)totalIncCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", TestUtils.format((double)transactionsPerSecond));
    }

    private long sum() {
        long result = 0L;
        for (AlphaProgrammaticLongRef ref : this.refs) {
            result += ref.get();
        }
        return result;
    }

    private AlphaProgrammaticLongRef[] createRefs() {
        AlphaProgrammaticLongRef[] refs = new AlphaProgrammaticLongRef[this.threadCount];
        for (int k = 0; k < this.threadCount; ++k) {
            refs[k] = (AlphaProgrammaticLongRef)this.refFactory.atomicCreateLongRef(0L);
        }
        return refs;
    }

    private AtomicIncThread[] createThreads() {
        AtomicIncThread[] threads = new AtomicIncThread[this.threadCount];
        for (int k = 0; k < this.threadCount; ++k) {
            threads[k] = new AtomicIncThread(k);
        }
        return threads;
    }

    public class AtomicIncThread
    extends TestThread {
        private int id;

        public AtomicIncThread(int id) {
            super("AtomicIncThread-" + id);
            this.id = id;
        }

        public void doRun() throws Exception {
            int k = 0;
            while ((long)k < AlphaProgrammaticLongRef_atomicWithoutStateSharedButSharedStmStressTest.this.incCountPerThread) {
                AlphaProgrammaticLongRef_atomicWithoutStateSharedButSharedStmStressTest.this.refs[this.id].atomicInc(1L);
                if (k % 1000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ++k;
            }
        }
    }
}

