/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRef;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticRef;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;

public class AlphaProgrammaticLongRef_constructionTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void constructorWithValue() {
        long version = this.stm.getVersion();
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(10L);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.___getLockOwner());
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        AlphaTransaction tx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().build().start();
        tx.abort();
        long version = this.stm.getVersion();
        try {
            new AlphaProgrammaticLongRef(tx, 10L);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        AlphaTransaction tx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().build().start();
        tx.commit();
        long version = this.stm.getVersion();
        try {
            new AlphaProgrammaticLongRef(tx, 10L);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        AlphaTransaction tx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().build().start();
        tx.prepare();
        long version = this.stm.getVersion();
        try {
            new AlphaProgrammaticLongRef(tx, 10L);
            Assert.fail();
        }
        catch (PreparedTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenNullTransaction_thenNullPointerException() {
        long version = this.stm.getVersion();
        try {
            new AlphaProgrammaticLongRef((AlphaTransaction)null, 10L);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenTransactionUsed() {
        AlphaTransaction tx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build().start();
        String value = "foo";
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef((Transaction)tx, (Object)value);
        Assert.assertSame((Object)value, (Object)ref.get((Transaction)tx));
        Assert.assertNull((Object)ref.___load());
        long version = this.stm.getVersion();
        tx.commit();
        Assert.assertSame((Object)value, (Object)ref.atomicGet());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenTransactionAborts() {
        AlphaTransaction tx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build().start();
        String value = "foo";
        long version = this.stm.getVersion();
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef((Transaction)tx, (Object)value);
        tx.abort();
        Assert.assertNull((Object)ref.___load());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

