/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.TooManyRetriesException;
import org.multiverse.stms.AbstractTransactionImpl;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRef;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRefTranlocal;

public class AlphaProgrammaticLongRef_incLongTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenNoTransactionAndLocked_thenTooManyRetriesException() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 1L);
        AlphaProgrammaticLongRefTranlocal committed = (AlphaProgrammaticLongRefTranlocal)ref.___load();
        AbstractTransactionImpl lockOwner = new AbstractTransactionImpl();
        ref.___tryLock((Transaction)lockOwner);
        long version = this.stm.getVersion();
        try {
            ref.inc(10L);
            Assert.fail();
        }
        catch (TooManyRetriesException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)lockOwner, (Object)ref.___getLockOwner());
        Assert.assertSame((Object)committed, (Object)ref.___load());
    }
}

