/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.programmatic.ProgrammaticLongRef;
import org.multiverse.api.programmatic.ProgrammaticRefFactory;

public class AlphaProgrammaticLongRef_incReadConsistencyStressTest {
    private volatile boolean stop;
    private int refCount = 10;
    private ProgrammaticLongRef[] refs;
    private Stm stm;
    private int readerCount = 10;

    @Before
    public void setUp() {
        this.stop = false;
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ProgrammaticRefFactory refFactory = this.stm.getProgrammaticRefFactoryBuilder().build();
        this.refs = new ProgrammaticLongRef[this.refCount];
        for (int k = 0; k < this.refs.length; ++k) {
            this.refs[k] = refFactory.atomicCreateLongRef(0L);
        }
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void testWithCommute() {
        this.test(true);
    }

    @Test
    public void testWithoutCommit() {
        this.test(false);
    }

    public void test(boolean commute) {
        CommutingIncThread incThread = new CommutingIncThread(commute);
        TestThread[] readThreads = new ReadThread[this.readerCount];
        for (int k = 0; k < readThreads.length; ++k) {
            readThreads[k] = new ReadThread(1);
        }
        TestUtils.startAll((TestThread[])new TestThread[]{incThread});
        TestUtils.startAll((TestThread[])readThreads);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)60000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])readThreads);
        TestUtils.joinAll((TestThread[])new TestThread[]{incThread});
    }

    public class CommutingIncThread
    extends TestThread {
        private final boolean commute;

        public CommutingIncThread(boolean commute) {
            super("IncThread");
            this.commute = commute;
        }

        public void doRun() throws Exception {
            int k = 0;
            while (!AlphaProgrammaticLongRef_incReadConsistencyStressTest.this.stop) {
                TestUtils.sleepRandomUs((int)10);
                if (k % 100000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ++k;
            }
        }

        public void inc() {
            for (ProgrammaticLongRef ref : AlphaProgrammaticLongRef_incReadConsistencyStressTest.this.refs) {
                if (!TestUtils.randomOneOf((int)5)) continue;
                if (this.commute) {
                    ref.commutingInc(1L);
                    continue;
                }
                ref.atomicInc(1L);
            }
        }
    }

    public class ReadThread
    extends TestThread {
        private long count;

        public ReadThread(int id) {
            super("ReadThread-" + id);
        }

        public void doRun() throws Exception {
            while (!AlphaProgrammaticLongRef_incReadConsistencyStressTest.this.stop) {
                this.read();
                TestUtils.sleepRandomUs((int)10);
                if (this.count % 100000L == 0L) {
                    System.out.printf("%s is at %s\n", this.getName(), this.count);
                }
                ++this.count;
            }
        }

        @TransactionalMethod(readonly=true, trackReads=false)
        private void read() {
            int sumT1 = 0;
            for (ProgrammaticLongRef ref : AlphaProgrammaticLongRef_incReadConsistencyStressTest.this.refs) {
                sumT1 = (int)((long)sumT1 + ref.get());
            }
            TestUtils.sleepRandomUs((int)10);
            int sumT2 = 0;
            for (ProgrammaticLongRef ref : AlphaProgrammaticLongRef_incReadConsistencyStressTest.this.refs) {
                sumT2 = (int)((long)sumT2 + ref.get());
            }
            Assert.assertEquals((long)sumT1, (long)sumT2);
        }
    }
}

