/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticRef;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticRefTranlocal;

public class AlphaProgrammaticRef_atomicCompareAndSetTest {
    private AlphaStm stm;
    private static final Long ONE = 1L;
    private static final Long TWO = 2L;
    private static final Long THREE = 3L;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenNotCommittedBefore_thenUncommittedReadConflict() {
        AlphaProgrammaticRef ref = AlphaProgrammaticRef.createUncommitted();
        long version = this.stm.getVersion();
        try {
            ref.atomicCompareAndSet((Object)ONE, (Object)TWO);
            Assert.fail();
        }
        catch (UncommittedReadConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.___load());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenValueMatches() {
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef(this.stm, (Object)ONE);
        long version = this.stm.getVersion();
        boolean result = ref.atomicCompareAndSet((Object)ONE, (Object)TWO);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((Object)TWO, (Object)ref.get());
        Assert.assertNull((Object)ref.___getLockOwner());
        AlphaProgrammaticRefTranlocal current = (AlphaProgrammaticRefTranlocal)ref.___load();
        Assert.assertNotNull((Object)current);
        Assert.assertTrue((boolean)current.isCommitted());
        Assert.assertEquals((Object)TWO, (Object)current.value);
        Assert.assertEquals((long)(version + 1L), (long)current.___writeVersion);
    }

    @Test
    public void whenLocked_thenTooManyRetriesException() {
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef(this.stm, (Object)ONE);
        AlphaProgrammaticRefTranlocal committed = (AlphaProgrammaticRefTranlocal)ref.___load();
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        long version = this.stm.getVersion();
        boolean result = ref.atomicCompareAndSet((Object)ONE, (Object)TWO);
        Assert.assertFalse((boolean)result);
        Assert.assertSame((Object)lockOwner, (Object)ref.___getLockOwner());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)committed, (Object)ref.___load());
    }

    @Test
    public void whenNoChange() {
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef(this.stm, (Object)ONE);
        AlphaProgrammaticRefTranlocal committed = (AlphaProgrammaticRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        boolean success = ref.atomicCompareAndSet((Object)ONE, (Object)ONE);
        Assert.assertTrue((boolean)success);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)ONE, (Object)ref.atomicGet());
        Assert.assertNull((Object)ref.___getLockOwner());
        Assert.assertSame((Object)committed, (Object)ref.___load());
    }

    @Test
    public void whenChangeThenListenersNotified() {
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef(this.stm, (Object)ONE);
        CheapLatch latch = new CheapLatch();
        ref.___registerRetryListener((Latch)latch, this.stm.getVersion() + 1L);
        ref.atomicCompareAndSet((Object)ONE, (Object)TWO);
        Assert.assertNull((Object)ref.___getListeners());
        Assert.assertTrue((boolean)latch.isOpen());
    }

    @Test
    public void whenValueNotMatches() {
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef(this.stm, (Object)ONE);
        AlphaProgrammaticRefTranlocal readonly = (AlphaProgrammaticRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        boolean result = ref.atomicCompareAndSet((Object)TWO, (Object)THREE);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)ONE, (Object)ref.get());
        Assert.assertNull((Object)ref.___getLockOwner());
        Assert.assertSame((Object)readonly, (Object)ref.___load());
    }
}

