/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticRef;

public class AlphaProgrammaticRef_getOrAwaitTest {
    private Stm stm;
    private TransactionFactory updateTxFactory;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.updateTxFactory = this.stm.getTransactionFactoryBuilder().build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenNotNull_thenValueReturned() {
        String oldRef = "foo";
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef((Object)oldRef);
        long version = this.stm.getVersion();
        String result = (String)ref.getOrAwait();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)oldRef, (Object)result);
    }

    @Test
    public void whenNull_retryError() {
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef();
        long version = this.stm.getVersion();
        Transaction tx = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        try {
            ref.getOrAwait();
            Assert.fail();
        }
        catch (Retry retry) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

