/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticRef;

public class AlphaProgrammaticRef_setPerformanceTest {
    private long transactionCount = 100000000L;
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void set() {
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef();
        long startNs = System.nanoTime();
        for (long k = 0L; k < this.transactionCount; ++k) {
            ref.set((Object)(k % 2L == 0L ? "foo" : "bar"));
            if (k % 10000000L != 0L) continue;
            System.out.println("at: " + k);
        }
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)this.transactionCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", transactionsPerSecond);
    }

    @Test
    public void setAtomic() {
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef();
        long startNs = System.nanoTime();
        for (long k = 0L; k < this.transactionCount; ++k) {
            ref.atomicSet((Object)(k % 2L == 0L ? "foo" : "bar"));
            if (k % 10000000L != 0L) continue;
            System.out.println("at: " + k);
        }
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)this.transactionCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s transactions/second\n", transactionsPerSecond);
    }
}

