/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticRef;

public class AlphaProgrammaticRef_setTest {
    private Stm stm;
    private TransactionFactory updateTxFactory;
    private TransactionFactory readonlyTxFactory;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.updateTxFactory = this.stm.getTransactionFactoryBuilder().setReadonly(false).build();
        this.readonlyTxFactory = this.stm.getTransactionFactoryBuilder().setReadonly(true).build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void testSetFromNullToNull() {
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef();
        long version = this.stm.getVersion();
        String result = (String)ref.set(null);
        Assert.assertNull((Object)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.get());
    }

    @Test
    public void testSetFromNullToNonNull() {
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef();
        long version = this.stm.getVersion();
        String newRef = "foo";
        String result = (String)ref.set((Object)newRef);
        Assert.assertNull((Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)newRef, (Object)ref.get());
    }

    @Test
    public void testSetFromNonNullToNull() {
        String oldRef = "foo";
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef((Object)oldRef);
        long version = this.stm.getVersion();
        String result = (String)ref.set(null);
        Assert.assertSame((Object)oldRef, (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.get());
    }

    @Test
    public void testSetChangedReferenced() {
        String oldRef = "foo";
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef((Object)oldRef);
        long version = this.stm.getVersion();
        String newRef = "bar";
        String result = (String)ref.set((Object)newRef);
        Assert.assertSame((Object)oldRef, (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)newRef, (Object)ref.get());
    }

    @Test
    public void testSetUnchangedReferences() {
        String oldRef = "foo";
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef((Object)oldRef);
        long version = this.stm.getVersion();
        String result = (String)ref.set((Object)oldRef);
        Assert.assertSame((Object)oldRef, (Object)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)oldRef, (Object)ref.get());
    }

    @Test
    public void testSetEqualIsNotUsedButReferenceEquality() {
        String oldRef = new String("foo");
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef((Object)oldRef);
        long version = this.stm.getVersion();
        String newRef = new String("foo");
        String result = (String)ref.set((Object)newRef);
        Assert.assertSame((Object)oldRef, (Object)result);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)newRef, (Object)ref.get());
    }

    @Test
    public void testSetAndUnsetIsNotSeenAsChange() {
        String oldRef = "foo";
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef((Object)oldRef);
        long version = this.stm.getVersion();
        Transaction tx = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        String newRef = "bar";
        ref.set((Object)newRef);
        ref.set((Object)oldRef);
        tx.commit();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)oldRef, (Object)ref.get());
    }

    @Test
    public void testSetOnReadonlyRefFailsWithReadonlyException() {
        String value = "foo";
        AlphaProgrammaticRef ref = new AlphaProgrammaticRef((Object)value);
        long version = this.stm.getVersion();
        Transaction tx = this.readonlyTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        try {
            ref.set(null);
            Assert.fail();
        }
        catch (ReadonlyException ex) {
            // empty catch block
        }
        ThreadLocalTransaction.clearThreadLocalTransaction();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)value, (Object)ref.get());
    }
}

