/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.programmatic.ProgrammaticRef;
import org.multiverse.api.programmatic.ProgrammaticRefFactory;

public class AlphaProgrammaticRef_stackStressTest {
    private int threadCount = 10;
    private volatile boolean stop;
    private int stackCapacity = 1000;
    private static final ProgrammaticRefFactory refFactory = GlobalStmInstance.getGlobalStmInstance().getProgrammaticRefFactoryBuilder().build();
    private Stack<String> stack;
    private static final String POISON = "poison";

    @Before
    public void setUp() {
        this.stop = false;
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stack = new Stack();
    }

    @Before
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        TestThread[] producers = new ProducerThread[this.threadCount];
        TestThread[] consumers = new ConsumerThread[this.threadCount];
        for (int k = 0; k < this.threadCount; ++k) {
            producers[k] = new ProducerThread(k);
            consumers[k] = new ConsumerThread(k);
        }
        TestUtils.startAll((TestThread[])producers);
        TestUtils.startAll((TestThread[])consumers);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)20000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])producers);
        TestUtils.joinAll((TestThread[])consumers);
        Assert.assertEquals((long)this.sum((ProducerThread[])producers), (long)this.sum((ConsumerThread[])consumers));
    }

    private long sum(ProducerThread[] threads) {
        long sum = 0L;
        for (ProducerThread t : threads) {
            sum += t.produceCount;
        }
        return sum;
    }

    private long sum(ConsumerThread[] threads) {
        long sum = 0L;
        for (ConsumerThread t : threads) {
            sum += t.consumeCount;
        }
        return sum;
    }

    static /* synthetic */ ProgrammaticRefFactory access$400() {
        return refFactory;
    }

    @TransactionalObject
    public class Stack<E> {
        private final ProgrammaticRef<Node<E>> head = AlphaProgrammaticRef_stackStressTest.access$400().atomicCreateRef(null);

        int size() {
            Node h = (Node)this.head.get();
            return h == null ? 0 : h.size;
        }

        void push(E item) {
            if (item == null) {
                throw new NullPointerException();
            }
            if (this.size() == AlphaProgrammaticRef_stackStressTest.this.stackCapacity) {
                StmUtils.retry();
            }
            this.head.set(new Node<E>(item, (Node)this.head.get()));
        }

        E pop() {
            if (this.head.isNull()) {
                StmUtils.retry();
            }
            Node h = (Node)this.head.get();
            this.head.set(h.next);
            return h.value;
        }

        class Node<E> {
            final E value;
            final Node<E> next;
            final int size;

            Node(E value, Node<E> next) {
                this.value = value;
                this.next = next;
                this.size = next == null ? 1 : next.size + 1;
            }
        }
    }

    public class ConsumerThread
    extends TestThread {
        private long consumeCount;

        public ConsumerThread(int id) {
            super("ConsumerThread-" + id);
        }

        public void doRun() throws Exception {
            boolean again;
            do {
                if (again = this.consume()) {
                    ++this.consumeCount;
                }
                if (this.consumeCount % 100000L != 0L) continue;
                System.out.printf("%s is at %s\n", this.getName(), this.consumeCount);
            } while (again);
        }

        @TransactionalMethod
        private boolean consume() {
            String item = (String)AlphaProgrammaticRef_stackStressTest.this.stack.pop();
            return !AlphaProgrammaticRef_stackStressTest.POISON.equals(item);
        }
    }

    public class ProducerThread
    extends TestThread {
        private long produceCount;

        public ProducerThread(int id) {
            super("ProducerThread-" + id);
        }

        public void doRun() throws Exception {
            while (!AlphaProgrammaticRef_stackStressTest.this.stop) {
                this.produce();
                if (this.produceCount % 100000L == 0L) {
                    System.out.printf("%s is at %s\n", this.getName(), this.produceCount);
                }
                ++this.produceCount;
            }
            AlphaProgrammaticRef_stackStressTest.this.stack.push(AlphaProgrammaticRef_stackStressTest.POISON);
        }

        @TransactionalMethod
        private void produce() {
            AlphaProgrammaticRef_stackStressTest.this.stack.push("foo");
        }
    }
}

