/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;

public class UnsharedAtomicLongPerformanceTest {
    private volatile boolean stop;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stop = false;
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test_1Threads() {
        this.test(1);
    }

    @Test
    public void test_2Threads() {
        this.test(2);
    }

    @Test
    public void test_4Threads() {
        this.test(4);
    }

    @Test
    public void test_8Threads() {
        this.test(8);
    }

    @Test
    public void test_16Threads() {
        this.test(16);
    }

    @Test
    public void test_32Threads() {
        this.test(32);
    }

    public void test(int threadCount) {
        TestThread[] threads = this.createThreads(threadCount);
        long startNs = System.nanoTime();
        TestUtils.startAll((TestThread[])threads);
        TestUtils.sleepMs((long)TestUtils.getStressTestDurationMs((long)20000L));
        this.stop = true;
        TestUtils.joinAll((TestThread[])threads);
        long totalIncCount = this.sum((AtomicIncThread[])threads);
        Assert.assertEquals((long)totalIncCount, (long)this.sum((AtomicIncThread[])threads));
        long durationNs = System.nanoTime() - startNs;
        double transactionsPerSecond = 1.0 * (double)totalIncCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        System.out.printf("Performance %s increments/second\n", TestUtils.format((double)transactionsPerSecond));
        System.out.printf("Performance %s increments/second per thread\n", TestUtils.format((double)(transactionsPerSecond / (double)threadCount)));
    }

    private long sum(AtomicIncThread[] threads) {
        long result = 0L;
        for (AtomicIncThread thread : threads) {
            result += thread.count;
        }
        return result;
    }

    private AtomicIncThread[] createThreads(int threadCount) {
        AtomicIncThread[] threads = new AtomicIncThread[threadCount];
        for (int k = 0; k < threadCount; ++k) {
            threads[k] = new AtomicIncThread(k);
        }
        return threads;
    }

    public class AtomicIncThread
    extends TestThread {
        private final AtomicLong ref;
        private long count;

        public AtomicIncThread(int id) {
            super("AtomicIncThread-" + id);
            this.ref = new AtomicLong();
        }

        public long get() {
            return this.ref.get();
        }

        public void doRun() throws Exception {
            while (!UnsharedAtomicLongPerformanceTest.this.stop) {
                this.ref.incrementAndGet();
                if (this.count % 100000000L == 0L) {
                    System.out.printf("%s is at %s\n", this.getName(), this.count);
                }
                ++this.count;
            }
        }
    }
}

