/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.LockNotFreeReadConflict;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.readonly.ArrayReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class ArrayReadonlyAlphaTransaction_openForReadTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stm = new AlphaStm(this.stmConfig);
    }

    public ArrayReadonlyAlphaTransaction createTransactionUnderTest() {
        return this.createTransactionUnderTest(new SpeculativeConfiguration(100));
    }

    public ArrayReadonlyAlphaTransaction createTransactionUnderTest(SpeculativeConfiguration speculativeConfig) {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true).withMaxRetries(10).withSpeculativeConfig(speculativeConfig);
        return new ArrayReadonlyAlphaTransaction(config, speculativeConfig.getMaximumArraySize());
    }

    @Test
    public void whenTxObjectNull_thenNullReturned() {
        ArrayReadonlyAlphaTransaction tx = this.createTransactionUnderTest();
        AlphaTranlocal tranlocal = tx.openForRead(null);
        Assert.assertNull((Object)tranlocal);
    }

    @Test
    public void whenNotCommittedBefore_thenUncommittedReadConflict() {
        ManualRef ref = ManualRef.createUncommitted();
        ArrayReadonlyAlphaTransaction tx = this.createTransactionUnderTest();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (UncommittedReadConflict uncommittedReadConflict) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenFirstTimeOpenForRead_thenReadTracked() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        ArrayReadonlyAlphaTransaction tx = this.createTransactionUnderTest();
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertTrue((boolean)found.isCommitted());
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertSame((Object)((Object)committed), (Object)((Object)found));
        Assert.assertEquals((Object)1, (Object)TestUtils.getField((Object)tx, (String)"firstFreeIndex"));
    }

    @Test
    public void whenSecondTimeOpenedForRead_thenNotAddedToAttachedSet() {
        ManualRef ref = new ManualRef(this.stm);
        ArrayReadonlyAlphaTransaction tx = this.createTransactionUnderTest();
        ManualRefTranlocal expected = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertTrue((boolean)found.isCommitted());
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertSame((Object)((Object)expected), (Object)((Object)found));
        Assert.assertEquals((Object)1, (Object)TestUtils.getField((Object)tx, (String)"firstFreeIndex"));
    }

    @Test
    public void whenDifferentOpenForReadsAreDone() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        ManualRef ref3 = new ManualRef(this.stm);
        ArrayReadonlyAlphaTransaction tx = this.createTransactionUnderTest();
        tx.openForRead((AlphaTransactionalObject)ref1);
        Assert.assertEquals((Object)1, (Object)TestUtils.getField((Object)tx, (String)"firstFreeIndex"));
        tx.openForRead((AlphaTransactionalObject)ref2);
        Assert.assertEquals((Object)2, (Object)TestUtils.getField((Object)tx, (String)"firstFreeIndex"));
        tx.openForRead((AlphaTransactionalObject)ref3);
        Assert.assertEquals((Object)3, (Object)TestUtils.getField((Object)tx, (String)"firstFreeIndex"));
    }

    @Test
    public void whenLockedButExactVersionMatch_thenSuccess() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTranlocal readonly = ref.___load();
        AlphaTransaction owner = (AlphaTransaction)Mockito.mock(AlphaTransaction.class);
        ref.___tryLock((Transaction)owner);
        ArrayReadonlyAlphaTransaction tx = this.createTransactionUnderTest();
        AlphaTranlocal tranlocal = tx.openForRead((AlphaTransactionalObject)ref);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)readonly, (Object)tranlocal);
    }

    @Test
    public void whenLockedAndVersionTooNew_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        ArrayReadonlyAlphaTransaction tx = this.createTransactionUnderTest();
        tx.start();
        ref.set(this.stm, 10);
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenLockedAndVersionTooOld_thenLockNotFreeReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        this.stm.getClock().tick();
        ArrayReadonlyAlphaTransaction tx = this.createTransactionUnderTest();
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        System.out.println("tx.maxRetryCount: " + tx.getConfiguration().getMaxRetries());
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (LockNotFreeReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenVersionTooNew_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm);
        ArrayReadonlyAlphaTransaction tx = this.createTransactionUnderTest();
        tx.start();
        ref.inc(this.stm);
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict oldVersionNotFoundReadConflict) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((Object)0, (Object)TestUtils.getField((Object)tx, (String)"firstFreeIndex"));
    }

    @Test
    public void whenMaximumCapacityExceeded_thenSpeculativeConfigurationFailure() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        ManualRef ref3 = new ManualRef(this.stm);
        ManualRef ref4 = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(3);
        ArrayReadonlyAlphaTransaction tx = this.createTransactionUnderTest(speculativeConfig);
        tx.openForRead((AlphaTransactionalObject)ref1);
        tx.openForRead((AlphaTransactionalObject)ref2);
        tx.openForRead((AlphaTransactionalObject)ref3);
        try {
            tx.openForRead((AlphaTransactionalObject)ref4);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure expected) {
            // empty catch block
        }
        Assert.assertEquals((long)5L, (long)speculativeConfig.getOptimalSize());
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        ArrayReadonlyAlphaTransaction tx = this.createTransactionUnderTest();
        tx.prepare();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (PreparedTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        ArrayReadonlyAlphaTransaction tx = this.createTransactionUnderTest();
        tx.commit();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        ArrayReadonlyAlphaTransaction tx = this.createTransactionUnderTest();
        tx.abort();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

