/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.LockNotFreeReadConflict;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.MapReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class MapReadonlyAlphaTransaction_openForReadTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MapReadonlyAlphaTransaction createSutTransaction() {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true).withMaxRetries(10);
        return new MapReadonlyAlphaTransaction(config);
    }

    @Test
    public void whenOpenForRead_thenNotLockTxObjects() {
        ManualRef ref = new ManualRef(this.stm);
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        ref.resetLockInfo();
        tx.openForRead((AlphaTransactionalObject)ref);
        ref.assertNoLockAcquired();
        ref.assertNoLocksReleased();
    }

    @Test
    public void whenNotCommittedBefore_thenUncommittedReadConflict() {
        ManualRef ref = ManualRef.createUncommitted();
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (UncommittedReadConflict uncommittedReadConflict) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenFirstTimeOpenedForRead_thenReturnReadonlyValue() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal found = tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertTrue((boolean)found.isCommitted());
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertSame((Object)found, (Object)((Object)committed));
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenSecondTimeLoadForRead_sameTranlocalIsReturned() {
        ManualRef ref = new ManualRef(this.stm);
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal expected = tx.openForRead((AlphaTransactionalObject)ref);
        AlphaTranlocal found = tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertTrue((boolean)found.isCommitted());
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertSame((Object)expected, (Object)found);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenVersionTooOld_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm);
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.start();
        ref.inc(this.stm);
        long expectedVersion = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
    }

    @Test
    public void whenLockedButExactVersionMatch_thenSuccess() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTranlocal readonly = ref.___load();
        AlphaTransaction owner = (AlphaTransaction)Mockito.mock(AlphaTransaction.class);
        ref.___tryLock((Transaction)owner);
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal tranlocal = tx.openForRead((AlphaTransactionalObject)ref);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)readonly, (Object)tranlocal);
    }

    @Test
    public void whenLockedAndVersionTooNew_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.start();
        ref.set(this.stm, 10);
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenLockedAndVersionTooOld_thenLockNotFreeReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        this.stm.getClock().tick();
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (LockNotFreeReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenAlreadyOpenedForRead_thenReadWillNotObserveChangesByOthers() {
        ManualRef ref = new ManualRef(this.stm);
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal expected = tx.openForRead((AlphaTransactionalObject)ref);
        ref.inc(this.stm);
        AlphaTranlocal found = tx.openForRead((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)expected, (Object)found);
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        ManualRef ref = new ManualRef(this.stm, 10);
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.prepare();
        long version = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (PreparedTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm, 10);
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.commit();
        long expectedVersion = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm, 10);
        MapReadonlyAlphaTransaction tx = this.createSutTransaction();
        tx.abort();
        long expectedVersion = this.stm.getVersion();
        try {
            tx.openForRead((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
    }
}

