/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.NoRetryPossibleException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.readonly.NonTrackingReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class NonTrackingReadonlyAlphaTransaction_registerRetryLatchTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public NonTrackingReadonlyAlphaTransaction createSutTransaction(SpeculativeConfiguration speculativeConfiguration) {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, false).withExplicitRetryAllowed(true).withSpeculativeConfig(speculativeConfiguration);
        return new NonTrackingReadonlyAlphaTransaction(config);
    }

    @Test
    public void whenSpeculativeNonAutomaticReadTrackingAndUsed_thenSpeculativeConfigurationFailure() {
        ManualRef ref = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(true, true, false, 100);
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction(speculativeConfig);
        tx.openForRead((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.isOpen());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertNull((Object)ref.___getListeners());
        Assert.assertTrue((boolean)speculativeConfig.isReadTrackingEnabled());
    }

    @Test
    public void whenSpeculativeNonAutomaticReadTrackingAndUnused_thenSpeculativeConfigurationFailure() {
        ManualRef ref = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(false, true, false, 100);
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction(speculativeConfig);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.isOpen());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertNull((Object)ref.___getListeners());
        Assert.assertTrue((boolean)speculativeConfig.isReadTrackingEnabled());
    }

    @Test
    public void whenExplicitNonAutomaticReadTrackingAndUnused_thenNoRetryPossibleException() {
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(false, false, false, 100);
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction(speculativeConfig);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException ex) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.isOpen());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)speculativeConfig.isReadTrackingEnabled());
    }

    @Test
    public void whenExplicitNonAutomaticReadTrackingAndUsed_thenNoRetryPossibleException() {
        ManualRef ref = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(true, false, true, 100);
        NonTrackingReadonlyAlphaTransaction tx = this.createSutTransaction(speculativeConfig);
        tx.openForRead((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.isOpen());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertNull((Object)ref.___getListeners());
        Assert.assertFalse((boolean)speculativeConfig.isReadTrackingEnabled());
    }
}

