/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.NoRetryPossibleException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.AlphaTransactionTestUtils;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.update.ArrayUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class ArrayUpdateAlphaTransaction_registerRetryLatchTest {
    private AlphaStmConfig stmConfig;
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public AlphaTransaction createSutTransaction() {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        return new ArrayUpdateAlphaTransaction(config, 100);
    }

    @Test
    public void whenExplicitRetryNotAllowed_thenNoRetryPossibleException() {
        ManualRef ref = new ManualRef(this.stm);
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withExplictRetryAllowed(false);
        ArrayUpdateAlphaTransaction tx = new ArrayUpdateAlphaTransaction(config, 100);
        tx.openForRead((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenNoAutomaticReadtracking_thenNoRetryPossibleException() {
        ManualRef ref = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(false, false, false, 100);
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withSpeculativeConfiguration(speculativeConfig).withReadTrackingEnabled(false);
        ArrayUpdateAlphaTransaction tx = new ArrayUpdateAlphaTransaction(config, 100);
        tx.openForWrite((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenSpeculativeNoAutomaticReadtracking_thenSpeculativeConfigurationFailure() {
        ManualRef ref = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(false, true, false, 100);
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withSpeculativeConfiguration(speculativeConfig).withReadTrackingEnabled(false);
        ArrayUpdateAlphaTransaction tx = new ArrayUpdateAlphaTransaction(config, 100);
        tx.openForWrite((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.isOpen());
        Assert.assertTrue((boolean)speculativeConfig.isReadTrackingEnabled());
    }

    @Test
    public void whenUnused_thenNoRetryPossibleException() {
        AlphaTransaction tx = this.createSutTransaction();
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException noRetryPossibleException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.isOpen());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenOnlyFresh_thenNoRetryPossibleException() {
        ManualRef ref = ManualRef.createUncommitted();
        AlphaTransaction tx = this.createSutTransaction();
        tx.openForConstruction((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException expected) {
            // empty catch block
        }
        AlphaTransactionTestUtils.assertHasNoListeners(ref);
        Assert.assertFalse((boolean)latch.isOpen());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenOpenedForWrite_thenListenerAppended() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.createSutTransaction();
        tx.openForWrite((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        tx.registerRetryLatch((Latch)latch);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
        AlphaTransactionTestUtils.assertHasListeners(ref, new Latch[]{latch});
    }

    @Test
    public void whenOpenedForRead_thenListenerAppended() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        tx.registerRetryLatch((Latch)latch);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
        AlphaTransactionTestUtils.assertHasListeners(ref, new Latch[]{latch});
    }

    @Test
    public void whenListenerAlreadyExist_listenerAppended() {
        ManualRef ref = new ManualRef(this.stm);
        CheapLatch latch1 = new CheapLatch();
        CheapLatch latch2 = new CheapLatch();
        AlphaTransaction tx1 = this.createSutTransaction();
        tx1.openForRead((AlphaTransactionalObject)ref);
        tx1.registerRetryLatch((Latch)latch1);
        AlphaTransaction tx2 = this.createSutTransaction();
        tx2.openForRead((AlphaTransactionalObject)ref);
        tx2.registerRetryLatch((Latch)latch2);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx2});
        Assert.assertFalse((boolean)latch1.isOpen());
        Assert.assertFalse((boolean)latch2.isOpen());
        AlphaTransactionTestUtils.assertHasListeners(ref, new Latch[]{latch2, latch1});
    }

    @Test
    public void whenMultipleObjectsTooListenToo_thenListenerIsAddedTooAllObjects() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        ManualRef ref3 = new ManualRef(this.stm);
        AlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref1);
        tx.openForRead((AlphaTransactionalObject)ref2);
        tx.openForRead((AlphaTransactionalObject)ref3);
        CheapLatch latch = new CheapLatch();
        tx.registerRetryLatch((Latch)latch);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
        AlphaTransactionTestUtils.assertHasListeners(ref1, new Latch[]{latch});
        AlphaTransactionTestUtils.assertHasListeners(ref2, new Latch[]{latch});
        AlphaTransactionTestUtils.assertHasListeners(ref3, new Latch[]{latch});
    }

    @Test
    public void whenListenVersionAlreadyIsThere_thenLatchIsOpenedAndNothingIsRegistered() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        ref.inc(this.stm);
        CheapLatch latch = new CheapLatch();
        tx.registerRetryLatch((Latch)latch);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)latch.isOpen());
        AlphaTransactionTestUtils.assertHasNoListeners(ref);
    }
}

