/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.WriteSkewConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.ArrayUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class ArrayUpdateAlphaTransaction_writeSkewTest {
    private AlphaStmConfig stmConfig;
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    public AlphaTransaction createSutTransaction(int size, boolean writeSkewAllowed) {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withReadTrackingEnabled(true).withWriteSkewAllowed(writeSkewAllowed);
        return new ArrayUpdateAlphaTransaction(config, size);
    }

    @Test
    public void testSettings() {
        AlphaTransaction tx1 = this.createSutTransaction(10, true);
        Assert.assertTrue((boolean)tx1.getConfiguration().isWriteSkewAllowed());
        Assert.assertTrue((boolean)tx1.getConfiguration().isReadTrackingEnabled());
        AlphaTransaction tx2 = this.createSutTransaction(10, false);
        Assert.assertFalse((boolean)tx2.getConfiguration().isWriteSkewAllowed());
        Assert.assertTrue((boolean)tx2.getConfiguration().isReadTrackingEnabled());
    }

    @Test
    public void whenWriteSkewDisallowed_thenWriteSkewConflict() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRefTranlocal committedRef1 = (ManualRefTranlocal)ref1.___load();
        ManualRef ref2 = new ManualRef(this.stm);
        ManualRefTranlocal committedRef2 = (ManualRefTranlocal)ref2.___load();
        AlphaTransaction tx1 = this.createSutTransaction(10, false);
        tx1.openForRead((AlphaTransactionalObject)ref1);
        ManualRefTranlocal tranlocalRef2 = (ManualRefTranlocal)tx1.openForWrite((AlphaTransactionalObject)ref2);
        ++tranlocalRef2.value;
        AlphaTransaction tx2 = this.createSutTransaction(10, false);
        tx2.openForRead((AlphaTransactionalObject)ref2);
        ManualRefTranlocal tranlocalRef1 = (ManualRefTranlocal)tx2.openForWrite((AlphaTransactionalObject)ref1);
        ++tranlocalRef1.value;
        tx1.commit();
        long version = this.stm.getVersion();
        try {
            tx2.commit();
            Assert.fail();
        }
        catch (WriteSkewConflict expected) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx2});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)((Object)committedRef1), (Object)ref1.___load());
        Assert.assertSame((Object)((Object)tranlocalRef2), (Object)ref2.___load());
    }

    @Test
    public void whenWriteSkewAllowed_writeSkewHappens() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        AlphaTransaction tx1 = this.createSutTransaction(10, true);
        tx1.openForRead((AlphaTransactionalObject)ref1);
        ManualRefTranlocal tranlocalRef2 = (ManualRefTranlocal)tx1.openForWrite((AlphaTransactionalObject)ref2);
        ++tranlocalRef2.value;
        AlphaTransaction tx2 = this.createSutTransaction(10, true);
        tx2.openForRead((AlphaTransactionalObject)ref2);
        ManualRefTranlocal tranlocalRef1 = (ManualRefTranlocal)tx2.openForWrite((AlphaTransactionalObject)ref1);
        ++tranlocalRef1.value;
        tx1.commit();
        long version = this.stm.getVersion();
        tx2.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx2});
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)((Object)tranlocalRef1), (Object)ref1.___load());
        Assert.assertSame((Object)((Object)tranlocalRef2), (Object)ref2.___load());
    }

    @Test
    public void withFourAccountsAndWriteSkewAllowed() {
        AlphaTransaction tx2;
        ManualRef accountA1 = new ManualRef(this.stm);
        ManualRef accountA2 = new ManualRef(this.stm);
        ManualRef accountB1 = new ManualRef(this.stm);
        ManualRef accountB2 = new ManualRef(this.stm);
        accountA1.set(this.stm, 50);
        accountB1.set(this.stm, 50);
        AlphaTransaction tx1 = this.createSutTransaction(10, true);
        if (accountA1.get(tx1) + accountA2.get(tx1) > 25) {
            accountA1.inc(tx1, -25);
            accountB1.inc(tx1, 25);
        }
        if (accountB1.get(tx2 = this.createSutTransaction(10, true)) + accountB2.get(tx2) > 25) {
            accountB2.inc(tx2, -25);
            accountA2.inc(tx2, 25);
        }
        tx1.commit();
        tx2.commit();
    }

    @Test
    public void withFourAccountsAndWriteSkewDisallowed_thenWriteSkewConflict() {
        AlphaTransaction tx2;
        ManualRef accountA1 = new ManualRef(this.stm);
        ManualRef accountA2 = new ManualRef(this.stm);
        ManualRef accountB1 = new ManualRef(this.stm);
        ManualRef accountB2 = new ManualRef(this.stm);
        accountA1.set(this.stm, 50);
        accountB1.set(this.stm, 50);
        AlphaTransaction tx1 = this.createSutTransaction(10, false);
        if (accountA1.get(tx1) + accountA2.get(tx1) > 25) {
            accountA1.inc(tx1, -25);
            accountB1.inc(tx1, 25);
        }
        if (accountB1.get(tx2 = this.createSutTransaction(10, false)) + accountB2.get(tx2) > 25) {
            accountB2.inc(tx2, -25);
            accountA2.inc(tx2, 25);
        }
        tx1.commit();
        try {
            tx2.commit();
            Assert.fail();
        }
        catch (WriteSkewConflict expected) {
            // empty catch block
        }
    }
}

