/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MapUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class MapUpdateAlphaTransaction_abortTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MapUpdateAlphaTransaction createSutTransaction() {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        return new MapUpdateAlphaTransaction(config);
    }

    @Test
    public void abortDoesNotLockDirtyObject() {
        ManualRef ref = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ++tranlocal.value;
        ref.resetLockInfo();
        tx.abort();
        ref.assertNoLocksReleased();
        ref.assertNoLockAcquired();
    }

    @Test
    public void abortDoesNotLockReadonlyObject() {
        ManualRef ref = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        ref.resetLockInfo();
        tx.abort();
        ref.assertNoLocksReleased();
        ref.assertNoLockAcquired();
    }

    @Test
    public void abortDoesNotLockFreshObject() {
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRef ref = new ManualRef((AlphaTransaction)tx, 0);
        tx.openForWrite((AlphaTransactionalObject)ref);
        ref.resetLockInfo();
        tx.abort();
        ref.assertNoLocksReleased();
        ref.assertNoLockAcquired();
    }

    @Test
    public void whenUnused() {
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        long startTime = this.stm.getVersion();
        tx.abort();
        Assert.assertEquals((long)startTime, (long)this.stm.getVersion());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenTransactionContainsReads() {
        ManualRef ref = new ManualRef(this.stm, 10);
        ManualRefTranlocal original = (ManualRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        tx.abort();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)((Object)original), (Object)ref.___load());
    }

    @Test
    public void whenTransactionContainsNonDirtyObject_thenChangesAreNotWritten() {
        ManualRef ref = new ManualRef(this.stm, 10);
        ManualRefTranlocal original = (ManualRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        tx.abort();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)((Object)original), (Object)ref.___load());
    }

    @Test
    public void whenTransactionContainsDirtyObject_thenChangesAreNotWritten() {
        ManualRef ref = new ManualRef(this.stm, 10);
        ManualRefTranlocal original = (ManualRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ++tranlocal.value;
        tx.abort();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)((Object)original), (Object)ref.___load());
    }

    @Test
    public void whenTransactionContainsFreshObject_thenFreshObjectGetsNoTranlocal() {
        long startVersion = this.stm.getVersion();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRef ref = new ManualRef((AlphaTransaction)tx, 10);
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)startVersion, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.___load());
    }

    @Test
    public void whenPreparedAndUnused_thenNothingHappens() {
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.prepare();
        long version = this.stm.getVersion();
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenPreparedAndDirty_thenResourcesReleased() {
        ManualRef ref = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ref.inc((AlphaTransaction)tx);
        tx.prepare();
        tx.abort();
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenPreparedAndDirty_thenChangesAreNotWritten() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ref.inc((AlphaTransaction)tx);
        tx.prepare();
        Assert.assertSame((Object)((Object)committed), (Object)ref.___load());
    }

    @Test
    public void abortComplexScenario() {
        ManualRef ref1 = new ManualRef(this.stm, 1);
        ManualRef ref2 = new ManualRef(this.stm, 1);
        ManualRef ref3 = new ManualRef(this.stm, 1);
        long startTime = this.stm.getVersion();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ref1.inc((AlphaTransaction)tx);
        ref2.inc((AlphaTransaction)tx);
        ref3.inc((AlphaTransaction)tx);
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)startTime, (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)ref1.get(this.stm));
        Assert.assertEquals((long)1L, (long)ref2.get(this.stm));
        Assert.assertEquals((long)1L, (long)ref3.get(this.stm));
    }
}

