/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.LockNotFreeWriteConflict;
import org.multiverse.api.exceptions.OptimisticLockFailedWriteConflict;
import org.multiverse.api.exceptions.WriteSkewConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRef;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MapUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class MapUpdateAlphaTransaction_commitTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MapUpdateAlphaTransaction createSutTransaction() {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        return new MapUpdateAlphaTransaction(config);
    }

    public MapUpdateAlphaTransaction createSutTransactionWithWriteSkew(boolean allowed) {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withWriteSkewAllowed(allowed);
        return new MapUpdateAlphaTransaction(config);
    }

    @Test
    public void freshObjectIsNotLocked() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = ManualRef.createUncommitted();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ref1.inc((AlphaTransaction)tx);
        AlphaTranlocal tranlocal2 = tx.openForConstruction((AlphaTransactionalObject)ref2);
        long version = this.stm.getVersion();
        ref1.resetLockInfo();
        ref2.resetLockInfo();
        tx.commit();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        ref2.assertNoLockAcquired();
        ref1.assertLockAcquired();
        Assert.assertNull((Object)ref1.___getLockOwner());
        Assert.assertNull((Object)ref2.___getLockOwner());
    }

    @Test
    public void lockIsNotAcquiredOnReadonlyTransaction() {
        ManualRef ref = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        ref.resetLockInfo();
        tx.commit();
        ref.assertNoLocksReleased();
        ref.assertNoLockAcquired();
    }

    @Test
    public void lockIsNotAcquiredOnReadonlyObjectInAnUpdateTransaction() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.openForWrite((AlphaTransactionalObject)ref1);
        tx.openForRead((AlphaTransactionalObject)ref2);
        ref2.resetLockInfo();
        tx.commit();
        ref2.assertNoLocksReleased();
        ref2.assertNoLockAcquired();
    }

    @Test
    public void lockIsAcquiredOnNonDirtyObjectInAnUpdateTransaction() {
        ManualRef ref = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.openForWrite((AlphaTransactionalObject)ref);
        ref.resetLockInfo();
        tx.commit();
        ref.assertNoLocksReleased();
        ref.assertNoLockAcquired();
    }

    @Test
    public void lockIsAcquiredOnDirtyObject() {
        ManualRef ref = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ++tranlocal.value;
        ref.resetLockInfo();
        tx.commit();
        ref.assertLockAcquired();
        ref.assertLockReleased();
    }

    @Test
    public void lockIsNotAcquiredOnFreshObject() {
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRef ref = new ManualRef((AlphaTransaction)tx, 0);
        tx.openForWrite((AlphaTransactionalObject)ref);
        ref.resetLockInfo();
        tx.commit();
        ref.assertNoLocksReleased();
        ref.assertNoLockAcquired();
    }

    @Test
    public void whenUnused() {
        long startVersion = this.stm.getVersion();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.commit();
        Assert.assertEquals((long)startVersion, (long)this.stm.getVersion());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenReadonly() {
        ManualRef ref = new ManualRef(this.stm, 10);
        AlphaTranlocal expectedTranlocal = ref.___load();
        long version = this.stm.getVersion();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)expectedTranlocal, (Object)ref.___load());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenDirty() {
        ManualRef ref = new ManualRef(this.stm, 10);
        long startVersion = this.stm.getVersion();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ref.inc((AlphaTransaction)tx);
        tx.commit();
        ManualRefTranlocal stored = (ManualRefTranlocal)ref.___load(this.stm.getVersion());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)(startVersion + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)11L, (long)stored.value);
        Assert.assertEquals((long)this.stm.getVersion(), (long)stored.getWriteVersion());
        Assert.assertEquals((Object)((Object)ref), (Object)stored.getTransactionalObject());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenCommutingWrites() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(1L);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ref.commutingInc((Transaction)tx, 1L);
        AlphaTranlocal tranlocal = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Assert.assertTrue((boolean)tranlocal.isCommuting());
        long version = this.stm.getVersion();
        tx.commit();
        Assert.assertNull((Object)ref.___getLockOwner());
        Assert.assertNull((Object)ref.___getListeners());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)2L, (long)ref.atomicGet());
        Assert.assertSame((Object)tranlocal, (Object)ref.___load());
        Assert.assertTrue((boolean)tranlocal.isCommitted());
        Assert.assertEquals((long)(version + 1L), (long)tranlocal.getWriteVersion());
        Assert.assertNull((Object)tranlocal.getOrigin());
    }

    @Test
    public void whenOnlyOpenedForConstruction_thenVersionNotIncreased() {
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        long startVersion = this.stm.getVersion();
        ManualRef ref = new ManualRef((AlphaTransaction)tx, 10);
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)startVersion, (long)this.stm.getVersion());
        ManualRefTranlocal stored = (ManualRefTranlocal)ref.___load(this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)stored.value);
        Assert.assertEquals((long)this.stm.getVersion(), (long)stored.getWriteVersion());
        Assert.assertEquals((Object)((Object)ref), (Object)stored.getTransactionalObject());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenNonDirty() {
        ManualRef ref = new ManualRef(this.stm, 10);
        AlphaTranlocal tranlocal = ref.___load();
        long startVersion = this.stm.getVersion();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.openForWrite((AlphaTransactionalObject)ref);
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)startVersion, (long)this.stm.getVersion());
        Assert.assertSame((Object)tranlocal, (Object)ref.___load());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenWriteConflict_thenVersionTooOldWriteConflict() {
        ManualRef ref = new ManualRef(this.stm, 0);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ref.inc(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        ++tranlocal.value;
        try {
            tx.commit();
            Assert.fail();
        }
        catch (OptimisticLockFailedWriteConflict expected) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)((Object)committed), (Object)ref.___load());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenLocked_thenCommitLockNotFreeWriteConflict() {
        ManualRef ref = new ManualRef(this.stm, 0);
        long version = this.stm.getVersion();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ref.inc((AlphaTransaction)tx);
        Transaction otherOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(otherOwner);
        try {
            tx.commit();
            Assert.fail();
        }
        catch (LockNotFreeWriteConflict e) {
            // empty catch block
        }
        ref.___releaseLock(otherOwner);
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)0L, (long)ref.get(this.stm));
    }

    @Test
    public void whenCommitted_thenIgnore() {
        ManualRef ref = new ManualRef(this.stm, 1);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ref.inc((AlphaTransaction)tx);
        tx.commit();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)((Object)tranlocal), (Object)ref.___load());
        Assert.assertEquals((long)2L, (long)ref.get(this.stm));
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm, 1);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ref.inc((AlphaTransaction)tx);
        tx.abort();
        long version = this.stm.getVersion();
        try {
            tx.commit();
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)ref.get(this.stm));
    }

    @Test
    public void complexScenario1() {
        ManualRef ref1 = new ManualRef(this.stm, 10);
        ManualRef ref2 = new ManualRef(this.stm, 20);
        long version = this.stm.getVersion();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ref1.inc((AlphaTransaction)tx);
        ref2.get((AlphaTransaction)tx);
        ManualRef ref3 = new ManualRef((AlphaTransaction)tx, 30);
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)11L, (long)ref1.get(this.stm));
        Assert.assertEquals((long)20L, (long)ref2.get(this.stm));
        Assert.assertEquals((long)30L, (long)ref3.get(this.stm));
        Assert.assertEquals((long)(version + 1L), (long)ref1.___load().getWriteVersion());
        Assert.assertEquals((long)(version + 1L), (long)ref3.___load().getWriteVersion());
        Assert.assertEquals((long)version, (long)ref2.___load().getWriteVersion());
    }

    @Test
    public void complexScenario2() {
        ManualRef ref1 = new ManualRef(this.stm, 1);
        ManualRef ref2 = new ManualRef(this.stm, 2);
        ManualRef ref3 = new ManualRef(this.stm, 3);
        long startVersion = this.stm.getVersion();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ref1.inc((AlphaTransaction)tx);
        ref2.inc((AlphaTransaction)tx);
        ref3.get((AlphaTransaction)tx);
        ManualRef ref4 = new ManualRef((AlphaTransaction)tx, 4);
        ref4.inc((AlphaTransaction)tx);
        ManualRef ref5 = new ManualRef((AlphaTransaction)tx, 5);
        ManualRef ref6 = new ManualRef((AlphaTransaction)tx, 6);
        tx.commit();
        Assert.assertEquals((long)(startVersion + 1L), (long)this.stm.getVersion());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)2L, (long)ref1.get(this.stm));
        Assert.assertEquals((long)3L, (long)ref2.get(this.stm));
        Assert.assertEquals((long)3L, (long)ref3.get(this.stm));
        Assert.assertEquals((long)5L, (long)ref4.get(this.stm));
        Assert.assertEquals((long)5L, (long)ref5.get(this.stm));
        Assert.assertEquals((long)6L, (long)ref6.get(this.stm));
        Assert.assertNull((Object)ref1.___getLockOwner());
        Assert.assertNull((Object)ref2.___getLockOwner());
        Assert.assertNull((Object)ref3.___getLockOwner());
        Assert.assertNull((Object)ref4.___getLockOwner());
        Assert.assertNull((Object)ref5.___getLockOwner());
        Assert.assertNull((Object)ref6.___getLockOwner());
    }

    @Test
    public void whenWriteSkewAllowed_thenCommit() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx1 = this.createSutTransactionWithWriteSkew(true);
        tx1.openForRead((AlphaTransactionalObject)ref1);
        ref2.inc((AlphaTransaction)tx1);
        MapUpdateAlphaTransaction tx2 = this.createSutTransactionWithWriteSkew(true);
        tx2.openForRead((AlphaTransactionalObject)ref2);
        ref1.inc((AlphaTransaction)tx2);
        tx1.commit();
        tx2.commit();
        Assert.assertEquals((long)1L, (long)ref1.get(this.stm));
        Assert.assertEquals((long)1L, (long)ref2.get(this.stm));
    }

    @Test
    public void whenWriteSkewDisallowed_theWriteSkewConflict() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx1 = this.createSutTransactionWithWriteSkew(false);
        tx1.openForRead((AlphaTransactionalObject)ref1);
        ref2.inc((AlphaTransaction)tx1);
        MapUpdateAlphaTransaction tx2 = this.createSutTransactionWithWriteSkew(false);
        tx2.openForRead((AlphaTransactionalObject)ref2);
        ref1.inc((AlphaTransaction)tx2);
        tx1.commit();
        try {
            tx2.commit();
            Assert.fail();
        }
        catch (WriteSkewConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)ref1.get(this.stm));
        Assert.assertEquals((long)1L, (long)ref2.get(this.stm));
    }
}

