/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.LockNotFreeReadConflict;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.UncommittedReadConflict;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTestUtils;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLongRef;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MapUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class MapUpdateAlphaTransaction_openForWriteTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MapUpdateAlphaTransaction createSutTransaction() {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        return new MapUpdateAlphaTransaction(config);
    }

    @Test
    public void whenVersionMatches() {
        ManualRef ref = new ManualRef(this.stm, 0);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertNotSame((Object)((Object)committed), (Object)((Object)found));
        Assert.assertSame((Object)((Object)committed), (Object)found.getOrigin());
        Assert.assertEquals((Object)((Object)ref), (Object)found.getTransactionalObject());
        Assert.assertEquals((long)committed.value, (long)found.value);
        Assert.assertTrue((boolean)found.isUncommitted());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenNullTxObject_thenNullPointerException() {
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.start();
        try {
            tx.openForWrite(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void openForWriteDoesNotLockAtomicObjects() {
        ManualRef ref = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ref.resetLockInfo();
        tx.openForWrite((AlphaTransactionalObject)ref);
        ref.assertNoLocksReleased();
        ref.assertNoLockAcquired();
    }

    @Test
    public void whenLockedAndVersionTooOld_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 1);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.start();
        ref.set(this.stm, 10);
        ManualRefTranlocal expectedTranlocal = (ManualRefTranlocal)ref.___load();
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        long version = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)((Object)expectedTranlocal), (Object)ref.___load());
    }

    @Test
    public void whenReadConflict_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.start();
        ref.inc(this.stm);
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict oldVersionNotFoundReadConflict) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenVersionTooNew_thenOldVersionNotFoundReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 0);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.start();
        ref.inc(this.stm);
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict oldVersionNotFoundReadConflict) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenLocked_thenLockNotFreeReadConflict() {
        ManualRef ref = new ManualRef(this.stm, 0);
        this.stmConfig.clock.tick();
        Transaction owner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(owner);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (LockNotFreeReadConflict expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenAlreadyOpenedForWrite_thenSameTranlocalReturned() {
        ManualRef ref = new ManualRef(this.stm, 0);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal exected = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ManualRefTranlocal found = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)((Object)exected), (Object)((Object)found));
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenAlreadyOpenedForRead_thenItIsUpgradedToOpenForWrite() {
        ManualRef ref = new ManualRef(this.stm, 20);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRefTranlocal read1 = (ManualRefTranlocal)tx.openForRead((AlphaTransactionalObject)ref);
        ManualRefTranlocal read2 = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertNotSame((Object)((Object)read1), (Object)((Object)read2));
        Assert.assertSame((Object)read2.getOrigin(), (Object)((Object)read1));
        Assert.assertTrue((boolean)read2.isUncommitted());
        Assert.assertSame((Object)read1.getTransactionalObject(), (Object)read2.getTransactionalObject());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenAlreadyOpenedForCommutingWrite_thenFixated() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 0L);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal openedForCommutingWrite = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        AlphaTranlocal found = tx.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)openedForCommutingWrite, (Object)found);
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertFalse((boolean)found.isCommitted());
    }

    @Test
    public void whenAlreadyOpenedForCommutingWriteAndLockedButVersionMatches() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 0L);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal openedForCommutingWrite = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        AlphaTranlocal found = tx.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertSame((Object)openedForCommutingWrite, (Object)found);
        Assert.assertFalse((boolean)found.isCommuting());
        Assert.assertFalse((boolean)found.isCommitted());
    }

    @Test
    public void whenAlreadyOpenedForCommutingWriteAndLockedAndVersionTooOld_thenOldVersionNotFoundReadConflict() {
        AlphaProgrammaticLongRef ref = new AlphaProgrammaticLongRef(this.stm, 0L);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        AlphaTranlocal openedForCommutingWrite = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        ref.atomicInc(10L);
        Transaction lockOwner = (Transaction)Mockito.mock(Transaction.class);
        ref.___tryLock(lockOwner);
        long version = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (OldVersionNotFoundReadConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)this.stm.getVersion(), (long)version);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)openedForCommutingWrite.isCommuting());
    }

    @Test
    public void whenOpenedForWriteOnDifferentTransactions_thenDifferentTranlocalsAreReturned() {
        ManualRef ref = new ManualRef(this.stm, 1);
        AlphaTransaction tx1 = AlphaTestUtils.startTrackingUpdateTransaction(this.stm);
        ManualRefTranlocal found1 = (ManualRefTranlocal)tx1.openForWrite((AlphaTransactionalObject)ref);
        AlphaTransaction tx2 = AlphaTestUtils.startTrackingUpdateTransaction(this.stm);
        ManualRefTranlocal found2 = (ManualRefTranlocal)tx2.openForWrite((AlphaTransactionalObject)ref);
        Assert.assertNotSame((Object)((Object)found1), (Object)((Object)found2));
    }

    @Test
    public void whenReferenceUncommitted_thenUncommittedReadConflict() {
        ManualRef ref = ManualRef.createUncommitted();
        AlphaTransaction tx = AlphaTestUtils.startTrackingUpdateTransaction(this.stm);
        long version = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (UncommittedReadConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm, 0);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.commit();
        long expectedVersion = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm, 0);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.abort();
        long expectedVersion = this.stm.getVersion();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)expectedVersion, (long)this.stm.getVersion());
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.prepare();
        try {
            tx.openForWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (PreparedTransactionException preparedTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
    }
}

