/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.Listeners;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.NoRetryPossibleException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.update.MapUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;
import org.multiverse.templates.TransactionTemplate;

public class MapUpdateAlphaTransaction_registerRetryLatchTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MapUpdateAlphaTransaction createSutTransaction() {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        return new MapUpdateAlphaTransaction(config);
    }

    public MapUpdateAlphaTransaction createSutTransactionWithoutReadTracking(SpeculativeConfiguration speculativeConfig) {
        UpdateConfiguration config = new UpdateConfiguration(this.stm.getClock()).withSpeculativeConfiguration(speculativeConfig).withExplictRetryAllowed(true).withReadTrackingEnabled(false);
        return new MapUpdateAlphaTransaction(config);
    }

    private List<Latch> getLatches(ManualRef ref) {
        LinkedList<Latch> result = new LinkedList<Latch>();
        for (Listeners listeners = ref.___getListeners(); listeners != null; listeners = listeners.getNext()) {
            result.add(listeners.getListener());
        }
        return result;
    }

    @Test
    public void whenExplicitRetryNotAllowed() {
        ManualRef ref = new ManualRef(this.stm);
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withExplictRetryAllowed(false);
        MapUpdateAlphaTransaction tx = new MapUpdateAlphaTransaction(config);
        tx.openForRead((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenExplicitNoAutomaticReadtracking_thenNoRetryPossibleException() {
        ManualRef ref = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(false, false, false, 100);
        MapUpdateAlphaTransaction tx = this.createSutTransactionWithoutReadTracking(speculativeConfig);
        tx.openForWrite((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)speculativeConfig.isReadTrackingEnabled());
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenSpeculativeNoAutomaticReadtracking_thenSpeculativeFailureException() {
        ManualRef ref = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(false, true, false, 100);
        MapUpdateAlphaTransaction tx = this.createSutTransactionWithoutReadTracking(speculativeConfig);
        tx.openForWrite((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)speculativeConfig.isReadTrackingEnabled());
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenFirstNoListeners_listenerAdded() {
        ManualRef ref = new ManualRef(this.stm);
        CheapLatch latch = new CheapLatch();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.openForWrite((AlphaTransactionalObject)ref);
        tx.registerRetryLatch((Latch)latch);
        List<Latch> listeners = this.getLatches(ref);
        Assert.assertEquals(Arrays.asList(latch), listeners);
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenDesiredUpdateAlreadyExecuted_thenListenerOpened() {
        ManualRef ref = new ManualRef(this.stm);
        CheapLatch latch = new CheapLatch();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.openForWrite((AlphaTransactionalObject)ref);
        ref.inc(this.stm);
        tx.registerRetryLatch((Latch)latch);
        Assert.assertTrue((boolean)latch.isOpen());
        Assert.assertNull((Object)ref.___getListeners());
    }

    @Test
    public void whenMultipleOpenForWrites_listenerAddedToEach() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        CheapLatch latch = new CheapLatch();
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.openForWrite((AlphaTransactionalObject)ref1);
        tx.openForWrite((AlphaTransactionalObject)ref2);
        tx.registerRetryLatch((Latch)latch);
        List<Latch> listeners1 = this.getLatches(ref1);
        Assert.assertEquals(Arrays.asList(latch), listeners1);
        Assert.assertFalse((boolean)latch.isOpen());
        List<Latch> listeners2 = this.getLatches(ref2);
        Assert.assertEquals(Arrays.asList(latch), listeners2);
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenAlreadyContainsListener_thenListenerIsAppended() {
        ManualRef ref = new ManualRef(this.stm);
        CheapLatch latch1 = new CheapLatch();
        MapUpdateAlphaTransaction tx1 = this.createSutTransaction();
        tx1.openForWrite((AlphaTransactionalObject)ref);
        tx1.registerRetryLatch((Latch)latch1);
        CheapLatch latch2 = new CheapLatch();
        MapUpdateAlphaTransaction tx2 = this.createSutTransaction();
        tx2.openForWrite((AlphaTransactionalObject)ref);
        tx2.registerRetryLatch((Latch)latch2);
        List<Latch> latches = this.getLatches(ref);
        Assert.assertEquals(Arrays.asList(latch2, latch1), latches);
        Assert.assertFalse((boolean)latch1.isOpen());
        Assert.assertFalse((boolean)latch2.isOpen());
    }

    @Test
    public void whenLatchNull_thenNullPointerException() {
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        try {
            tx.registerRetryLatch(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenUnused_thenNoRetryPossibleException() {
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException noRetryPossibleException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenOnlyFreshObjects_thenNoRetryPossibleException() {
        MapUpdateAlphaTransaction tx = this.createSutTransaction();
        ManualRef ref = new ManualRef((AlphaTransaction)tx, 0);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException ex) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.isOpen());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void integrationTest_abortAndRetryOnSingleObject() {
        final ManualRef ref = new ManualRef(this.stm, 0);
        TestThread thread = new TestThread(){

            public void doRun() {
                TransactionFactory factory = MapUpdateAlphaTransaction_registerRetryLatchTest.this.stm.getTransactionFactoryBuilder().setExplicitRetryAllowed(true).setReadTrackingEnabled(true).build();
                new TransactionTemplate(factory){

                    public Object execute(Transaction t) throws Exception {
                        AlphaTransaction tx = (AlphaTransaction)ThreadLocalTransaction.getThreadLocalTransaction();
                        if (ref.get(tx) == 0) {
                            StmUtils.retry();
                        }
                        return null;
                    }
                }.execute();
            }
        };
        thread.start();
        TestUtils.sleepMs((long)300L);
        Assert.assertTrue((boolean)thread.isAlive());
        ref.set(this.stm, 1);
        TestUtils.sleepMs((long)300L);
        TestUtils.joinAll((TestThread[])new TestThread[]{thread});
    }

    @Test
    public void integrationTest_abortAndRetryOnMultipleObjects() {
        final ManualRef ref1 = new ManualRef(this.stm, 0);
        final ManualRef ref2 = new ManualRef(this.stm, 0);
        final ManualRef ref3 = new ManualRef(this.stm, 0);
        TestThread thread = new TestThread(){

            public void doRun() {
                TransactionFactory factory = MapUpdateAlphaTransaction_registerRetryLatchTest.this.stm.getTransactionFactoryBuilder().setExplicitRetryAllowed(true).setReadTrackingEnabled(true).build();
                new TransactionTemplate(factory){

                    public Object execute(Transaction t) throws Exception {
                        AlphaTransaction tx = (AlphaTransaction)ThreadLocalTransaction.getThreadLocalTransaction();
                        if (ref1.get(tx) == 0 && ref2.get(tx) == 0 && ref3.get(tx) == 0) {
                            StmUtils.retry();
                        }
                        return null;
                    }
                }.execute();
            }
        };
        thread.start();
        TestUtils.sleepMs((long)300L);
        Assert.assertTrue((boolean)thread.isAlive());
        ref2.set(this.stm, 1);
        TestUtils.sleepMs((long)300L);
        TestUtils.joinAll((TestThread[])new TestThread[]{thread});
    }
}

