/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.NoRetryPossibleException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.AlphaTransactionTestUtils;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.update.MonoUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class MonoUpdateAlphaTransaction_registerRetryLatchTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MonoUpdateAlphaTransaction createSutTransaction() {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        return new MonoUpdateAlphaTransaction(config);
    }

    public MonoUpdateAlphaTransaction createSutTransactionWithoutAutomaticReadTracking(SpeculativeConfiguration speculativeConfig) {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withExplictRetryAllowed(true).withReadTrackingEnabled(false).withSpeculativeConfiguration(speculativeConfig);
        return new MonoUpdateAlphaTransaction(config);
    }

    @Test
    public void whenNullLatch_thenNullPointerException() {
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        try {
            tx.registerRetryLatch(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenExplicitNoAutomaticReadtracking_thenNoRetryPossibleException() {
        ManualRef ref = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(false, false, false, 100);
        MonoUpdateAlphaTransaction tx = this.createSutTransactionWithoutAutomaticReadTracking(speculativeConfig);
        tx.openForWrite((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.isOpen());
        Assert.assertFalse((boolean)speculativeConfig.isReadTrackingEnabled());
    }

    @Test
    public void whenSpeculativeNoAutomaticReadtracking_thenSpeculativeConfigurationFailure() {
        ManualRef ref = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(false, true, false, 100);
        MonoUpdateAlphaTransaction tx = this.createSutTransactionWithoutAutomaticReadTracking(speculativeConfig);
        tx.openForWrite((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.isOpen());
        Assert.assertTrue((boolean)speculativeConfig.isReadTrackingEnabled());
    }

    @Test
    public void whenUnused_thenNoRetryPossibleException() {
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException noRetryPossibleException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenAlreadyOpenedForRead_thenListenerAdded() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        tx.registerRetryLatch((Latch)latch);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
        AlphaTransactionTestUtils.assertHasListeners(ref, new Latch[]{latch});
    }

    @Test
    public void whenAlreadyOpenedForWrite_thenListenerAdded() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.openForWrite((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        tx.registerRetryLatch((Latch)latch);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
        AlphaTransactionTestUtils.assertHasListeners(ref, new Latch[]{latch});
    }

    @Test
    public void whenExplicitRetryNotAllowed() {
        ManualRef ref = new ManualRef(this.stm);
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withExplictRetryAllowed(false);
        MonoUpdateAlphaTransaction tx = new MonoUpdateAlphaTransaction(config);
        tx.openForRead((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenFresh_thenNoRetryPossibleException() {
        ManualRef ref = ManualRef.createUncommitted();
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.openForConstruction((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
        AlphaTransactionTestUtils.assertHasNoListeners(ref);
    }

    @Test
    public void whenListenersAlreadyPresent_newListenerAppended() {
        ManualRef ref = new ManualRef(this.stm);
        CheapLatch latch1 = new CheapLatch();
        CheapLatch latch2 = new CheapLatch();
        MonoUpdateAlphaTransaction tx1 = this.createSutTransaction();
        tx1.openForRead((AlphaTransactionalObject)ref);
        tx1.registerRetryLatch((Latch)latch1);
        MonoUpdateAlphaTransaction tx2 = this.createSutTransaction();
        tx2.openForRead((AlphaTransactionalObject)ref);
        tx2.registerRetryLatch((Latch)latch2);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx2});
        Assert.assertFalse((boolean)latch1.isOpen());
        Assert.assertFalse((boolean)latch2.isOpen());
        AlphaTransactionTestUtils.assertHasListeners(ref, new Latch[]{latch2, latch1});
    }

    @Test
    public void whenVersionAlreadyThere_thenLatchOpenedAndNotRegistered() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.createSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        ref.inc(this.stm);
        CheapLatch latch = new CheapLatch();
        tx.registerRetryLatch((Latch)latch);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)latch.isOpen());
        AlphaTransactionTestUtils.assertHasNoListeners(ref);
    }
}

