/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.templates.OrElseTemplate;
import org.multiverse.templates.TransactionTemplate;
import org.multiverse.transactional.refs.IntRef;

public class OrElseTemplateTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.setThreadLocalTransaction(null);
    }

    public Transaction startUpdateTransaction() {
        Transaction t = this.stm.getTransactionFactoryBuilder().setReadTrackingEnabled(true).setReadonly(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        return t;
    }

    @Test
    public void changesInLeftBranchAreNotUnsetWhenTheRightBranchIsEntered() {
        final IntRef leftRef = new IntRef();
        Transaction tx = this.startUpdateTransaction();
        new OrElseTemplate(tx){

            public Object either(Transaction tx) {
                leftRef.set(1);
                StmUtils.retry();
                return null;
            }

            public Object orelse(Transaction tx) {
                Assert.assertEquals((long)1L, (long)leftRef.get());
                return null;
            }
        }.execute();
        Assert.assertEquals((long)1L, (long)leftRef.get());
    }

    @Test
    public void testWaitOnLeftBranch() {
        IntRef orRef = new IntRef();
        IntRef elseRef = new IntRef();
        WThread thread = new WThread(orRef, elseRef);
        thread.start();
        TestUtils.sleepMs((long)300L);
        TestUtils.assertAlive((Thread[])new Thread[]{thread});
        orRef.inc();
        TestUtils.joinAll((TestThread[])new TestThread[]{thread});
        Assert.assertEquals((Object)"run", (Object)thread.result);
    }

    @Test
    public void testWaitOnRightBranch() {
        IntRef orRef = new IntRef();
        IntRef elseRef = new IntRef();
        WThread thread = new WThread(orRef, elseRef);
        thread.start();
        TestUtils.sleepMs((long)300L);
        TestUtils.assertAlive((Thread[])new Thread[]{thread});
        elseRef.inc();
        TestUtils.joinAll((TestThread[])new TestThread[]{thread});
        Assert.assertEquals((Object)"orelserun", (Object)thread.result);
    }

    @Test
    public void testThreadLocalTx() {
        final Transaction startedTx = this.startUpdateTransaction();
        new OrElseTemplate(){

            public Object either(Transaction tx) {
                Assert.assertSame((Object)startedTx, (Object)tx);
                StmUtils.retry();
                return null;
            }

            public Object orelse(Transaction tx) {
                Assert.assertSame((Object)startedTx, (Object)tx);
                return null;
            }
        }.execute();
        Assert.assertSame((Object)startedTx, (Object)ThreadLocalTransaction.getThreadLocalTransaction());
    }

    @Test
    public void testRunWasSuccess() {
        final IntRef v = new IntRef(0);
        Transaction t = this.startUpdateTransaction();
        new OrElseTemplate(){

            public Object either(Transaction t) {
                v.set(10);
                return null;
            }

            public Object orelse(Transaction t) {
                Assert.fail();
                return null;
            }
        }.execute();
        t.commit();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        Assert.assertEquals((long)10L, (long)v.get());
    }

    @Test
    public void testRunWasFailureTryOrElseRun() {
        final IntRef v = new IntRef(0);
        Transaction t = this.startUpdateTransaction();
        new OrElseTemplate(){

            public Object either(Transaction t) {
                v.set(10);
                StmUtils.retry();
                return null;
            }

            public Object orelse(Transaction t) {
                v.set(20);
                return null;
            }
        }.execute();
        t.commit();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        Assert.assertEquals((long)20L, (long)v.get());
    }

    @Test
    public void testRunWasFailureTryOrElseRunWasAlsoFailure() {
        final IntRef v = new IntRef(0);
        Transaction t = this.startUpdateTransaction();
        try {
            new OrElseTemplate(){

                public Object either(Transaction t) {
                    v.set(10);
                    StmUtils.retry();
                    return null;
                }

                public Object orelse(Transaction t) {
                    v.set(20);
                    StmUtils.retry();
                    return null;
                }
            }.execute();
            Assert.fail();
        }
        catch (Retry retry) {
            // empty catch block
        }
        t.abort();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{t});
        Assert.assertEquals((long)0L, (long)v.get());
    }

    class WThread
    extends TestThread {
        private final IntRef orRef;
        private final IntRef elseRef;
        private String result;

        WThread(IntRef orRef, IntRef elseRef) {
            super("WaitThread");
            this.orRef = orRef;
            this.elseRef = elseRef;
        }

        public void doRun() throws Exception {
            TransactionFactory txFactory = OrElseTemplateTest.this.stm.getTransactionFactoryBuilder().setReadonly(false).setReadTrackingEnabled(true).build();
            this.result = (String)new TransactionTemplate<String>(txFactory){

                public String execute(Transaction t) throws Exception {
                    return (String)new OrElseTemplate<String>(){

                        public String either(Transaction tx) {
                            if (WThread.this.orRef.get() == 0) {
                                StmUtils.retry();
                            }
                            return "run";
                        }

                        public String orelse(Transaction tx) {
                            if (WThread.this.elseRef.get() == 0) {
                                StmUtils.retry();
                            }
                            return "orelserun";
                        }
                    }.execute();
                }
            }.execute();
        }
    }
}

