/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.TransactionFactoryBuilder;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.templates.TransactionBoilerplate;

public class TransactionBoilerplate_constructionTest {
    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test(expected=NullPointerException.class)
    public void whenNullStm_thenNullPointerException() {
        new TransactionBoilerplate((Stm)null);
    }

    @Test
    public void whenStm() {
        Stm stm = (Stm)Mockito.mock(Stm.class);
        TransactionFactoryBuilder txFactoryBuilder = (TransactionFactoryBuilder)Mockito.mock(TransactionFactoryBuilder.class);
        TransactionFactory txFactory = (TransactionFactory)Mockito.mock(TransactionFactory.class);
        Mockito.when((Object)stm.getTransactionFactoryBuilder()).thenReturn((Object)txFactoryBuilder);
        Mockito.when((Object)txFactoryBuilder.build()).thenReturn((Object)txFactory);
        TransactionBoilerplate boilerplate = new TransactionBoilerplate(stm);
        Assert.assertSame((Object)txFactory, (Object)boilerplate.getTransactionFactory());
        Assert.assertTrue((boolean)boilerplate.isThreadLocalAware());
        Assert.assertNull((Object)boilerplate.getTransactionLifecycleListener());
    }

    @Test(expected=NullPointerException.class)
    public void whenNullTransactionFactory_thenNullPointerException() {
        new TransactionBoilerplate((TransactionFactory)null);
    }

    @Test
    public void whenTxFactoryUsed() {
        TransactionFactory txFactory = (TransactionFactory)Mockito.mock(TransactionFactory.class);
        TransactionBoilerplate boilerplate = new TransactionBoilerplate(txFactory);
        Assert.assertSame((Object)txFactory, (Object)boilerplate.getTransactionFactory());
        Assert.assertNull((Object)boilerplate.getTransactionLifecycleListener());
        Assert.assertTrue((boolean)boilerplate.isThreadLocalAware());
    }

    @Test(expected=NullPointerException.class)
    public void whenNullTransactionFactoryAndOtherArguments_thenNullPointerException() {
        new TransactionBoilerplate((TransactionFactory)null, (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class), true);
    }

    @Test
    public void whenFullConstructor() {
        TransactionFactory txFactory = (TransactionFactory)Mockito.mock(TransactionFactory.class);
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        TransactionBoilerplate boilerplate = new TransactionBoilerplate(txFactory, listener, false);
        Assert.assertSame((Object)txFactory, (Object)boilerplate.getTransactionFactory());
        Assert.assertSame((Object)listener, (Object)boilerplate.getTransactionLifecycleListener());
        Assert.assertFalse((boolean)boilerplate.isThreadLocalAware());
    }
}

