/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.TraceLevel;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.OldVersionNotFoundReadConflict;
import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.api.exceptions.TooManyRetriesException;
import org.multiverse.templates.InvisibleCheckedException;
import org.multiverse.templates.TransactionTemplate;
import org.multiverse.transactional.refs.IntRef;

public class TransactionTemplateTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    public Transaction startThreadLocalUpdateTransaction() {
        Transaction t = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        return t;
    }

    @Test
    public void testEmptyTemplate() {
        long version = this.stm.getVersion();
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                return null;
            }
        }.execute();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNotNull((Object)ThreadLocalTransaction.getThreadLocalTransaction());
    }

    @Test
    public void testSelfCreatedTransaction() {
        final IntRef value = new IntRef(0);
        long version = this.stm.getVersion();
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                value.inc();
                return null;
            }
        }.execute();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertNotNull((Object)ThreadLocalTransaction.getThreadLocalTransaction());
        Assert.assertEquals((long)1L, (long)value.get());
    }

    @Test
    public void testLiftingOnExistingTransaction() {
        final IntRef value = new IntRef(0);
        Transaction t = this.startThreadLocalUpdateTransaction();
        long startVersion = this.stm.getVersion();
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                value.inc();
                return null;
            }
        }.execute();
        Assert.assertSame((Object)t, (Object)ThreadLocalTransaction.getThreadLocalTransaction());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{t});
        Assert.assertEquals((long)startVersion, (long)this.stm.getVersion());
        t.commit();
        Assert.assertEquals((long)(startVersion + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)t, (Object)ThreadLocalTransaction.getThreadLocalTransaction());
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        Assert.assertEquals((long)1L, (long)value.get());
    }

    @Test
    public void notThreadLocalAwarePreventsLifting() {
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setReadonly(false).build();
        final Transaction outerTx = txFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)outerTx);
        new TransactionTemplate(txFactory, false, true){

            public Object execute(Transaction innerTx) throws Exception {
                Assert.assertNotSame((Object)innerTx, (Object)outerTx);
                return null;
            }
        }.execute();
        Assert.assertSame((Object)outerTx, (Object)ThreadLocalTransaction.getThreadLocalTransaction());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{outerTx});
    }

    @Test
    public void testExplicitAbort() {
        final IntRef value = new IntRef(0);
        long version = this.stm.getVersion();
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).setTraceLevel(TraceLevel.fine).build();
        try {
            new TransactionTemplate(txFactory){

                public Object execute(Transaction tx) throws Exception {
                    System.out.println("loglevel: " + tx.getConfiguration().getTraceLevel());
                    System.out.println("tx.status: " + tx.getStatus());
                    value.inc();
                    System.out.println("tx.status: " + tx.getStatus());
                    tx.abort();
                    System.out.println("tx.status: " + tx.getStatus());
                    return null;
                }
            }.execute();
            Assert.fail();
        }
        catch (DeadTransactionException ignore) {
            // empty catch block
        }
        Assert.assertNotNull((Object)ThreadLocalTransaction.getThreadLocalTransaction());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)0L, (long)value.get());
    }

    @Test
    public void testExplicitCommit() {
        final IntRef value = new IntRef(0);
        long version = this.stm.getVersion();
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                value.inc();
                t.commit();
                return null;
            }
        }.execute();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertNotNull((Object)ThreadLocalTransaction.getThreadLocalTransaction());
        Assert.assertEquals((long)1L, (long)value.get());
    }

    @Test
    public void testRuntimeExceptionDoesNotCommitChanges() {
        final IntRef value = new IntRef(0);
        final RuntimeException ex = new RuntimeException();
        try {
            new TransactionTemplate(){

                public Object execute(Transaction t) throws Exception {
                    value.inc();
                    throw ex;
                }
            }.execute();
        }
        catch (Exception found) {
            Assert.assertSame((Object)ex, (Object)found);
        }
        Assert.assertEquals((long)0L, (long)value.get());
    }

    @Test
    public void testCheckedException() {
        final IntRef value = new IntRef(0);
        final IOException ex = new IOException();
        try {
            new TransactionTemplate(){

                public Object execute(Transaction t) throws Exception {
                    value.inc();
                    throw ex;
                }
            }.execute();
        }
        catch (InvisibleCheckedException found) {
            Assert.assertSame((Object)ex, (Object)found.getCause());
        }
        Assert.assertEquals((long)0L, (long)value.get());
    }

    @Test
    public void testRecursionDoesntCallProblems() {
        IntRef ref = new IntRef();
        long version = this.stm.getVersion();
        this.recursiveCall(100, ref, 10);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    public void recursiveCall(final int depth, final IntRef ref, final int value) {
        if (depth == 0) {
            ref.set(value);
        } else {
            new TransactionTemplate(){

                public Object execute(Transaction t) throws Exception {
                    TransactionTemplateTest.this.recursiveCall(depth - 1, ref, value);
                    return null;
                }
            }.execute();
        }
    }

    @Test
    public void tooManyRetries() {
        int retryCount = 10;
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setReadonly(false).setMaxRetries(retryCount).build();
        final IntRef ref = new IntRef();
        final IntHolder executeCounter = new IntHolder();
        long version = this.stm.getVersion();
        try {
            new TransactionTemplate(txFactory){

                public Object execute(Transaction t) throws Exception {
                    ++executeCounter.value;
                    ref.inc();
                    throw new OldVersionNotFoundReadConflict();
                }
            }.execute();
            Assert.fail();
        }
        catch (TooManyRetriesException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)(retryCount + 1), (long)executeCounter.value);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)0L, (long)ref.get());
    }

    @Test
    public void whenReadonlyAndWrite_thenReadonlyException() {
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setReadonly(true).build();
        final IntRef ref = new IntRef(0);
        long version = this.stm.getVersion();
        try {
            new TransactionTemplate(txFactory){

                public Object execute(Transaction t) throws Exception {
                    ref.inc();
                    return null;
                }
            }.execute();
        }
        catch (ReadonlyException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)0L, (long)ref.get());
    }

    private static class IntHolder {
        int value;

        private IntHolder() {
        }
    }
}

