/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.arrays;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.transactional.arrays.TransactionalReferenceArray;

public class TransactionalReferenceArray_accessTest {
    @Test(expected=IndexOutOfBoundsException.class)
    public void set_whenIndexTooSmall_thenIndexOutOfBoundsException() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(5);
        array.set(-1, (Object)"foo");
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void set_whenIndexTooBig_thenIndexOutOfBoundsException() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(5);
        array.set(6, (Object)"foo");
    }

    @Test
    public void set_whenEmptyCellWritten() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(5);
        String result = (String)array.set(4, (Object)"foo");
        Assert.assertNull((Object)result);
        Assert.assertEquals((Object)"foo", (Object)array.get(4));
    }

    @Test
    public void set_whenOverwrite() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(5);
        array.set(4, (Object)"foo");
        String result = (String)array.set(4, (Object)"bar");
        Assert.assertEquals((Object)"foo", (Object)result);
        Assert.assertEquals((Object)"bar", (Object)array.get(4));
    }

    @Test
    public void get_readingEmptyCell() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(5);
        String result = (String)array.get(3);
        Assert.assertNull((Object)result);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void get_whenIndexTooSmall_thenIndexOutOfBoundsException() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(5);
        array.get(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void get_whenIndexTooBig_thenIndexOutOfBoundsException() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(5);
        array.get(6);
    }
}

