/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.arrays;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.transactional.arrays.TransactionalReferenceArray;

public class TransactionalReferenceArray_atomicGetTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void whenIndexTooBig_thenIndexOutOfBoundsException() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        array.atomicGet(10);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void whenIndexTooSmall_thenIndexOutOfBoundsException() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        array.atomicGet(-1);
    }

    @Test
    public void test() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        int index = 5;
        long version = this.stm.getVersion();
        array.atomicGet(index);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        String update = "foo";
        array.atomicSet(index, (Object)update);
        version = this.stm.getVersion();
        Assert.assertSame((Object)update, (Object)array.atomicGet(index));
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenTransactionAvailable_thenIgnored() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        Transaction tx = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        array.set(5, (Object)"foo");
        Assert.assertNull((Object)array.atomicGet(5));
    }
}

