/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.arrays;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.internal.util.StringJoiner;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.transactional.arrays.TransactionalReferenceArray;

public class TransactionalReferenceArray_setTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void whenIndexTooBig_thenIndexOutOfBoundsException() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        array.set(10, (Object)"foo");
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void whenIndexTooSmall_thenIndexOutOfBoundsException() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        array.set(-1, (Object)"foo");
    }

    @Test
    public void whenNoTransactionAvailable_thenExecutedAtomically() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        String update = "foo";
        long version = this.stm.getVersion();
        array.set(5, (Object)update);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)update, (Object)array.get(5));
    }

    @Test
    public void whenTransactionAvailable_thenThatTransactionIsUsed() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        Transaction tx = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        long version = this.stm.getVersion();
        array.set(1, (Object)"foo");
        tx.abort();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)array.get(1));
    }

    @Test
    public void whenNoChange() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        long version = this.stm.getVersion();
        array.set(5, null);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)array.atomicGet(5));
    }

    @Test
    public void whenListenersAvailable_thenTheyAreNotified() {
        TransactionalReferenceArray array = new TransactionalReferenceArray(10);
        WaitThread t = new WaitThread(0, (TransactionalReferenceArray<Integer>)array);
        TestUtils.startAll((TestThread[])new TestThread[]{t});
        TestUtils.sleepMs((long)500L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        array.set(3, (Object)1);
        StringJoiner.join((Object[])new Object[]{t});
    }

    class WaitThread
    extends TestThread {
        final TransactionalReferenceArray<Integer> array;

        WaitThread(int id, TransactionalReferenceArray<Integer> array) {
            super("WaitThread-" + id);
            this.array = array;
        }

        @TransactionalMethod
        public void doRun() throws Exception {
            for (int k = 0; k < this.array.length(); ++k) {
                if (this.array.get(k) == null) continue;
                return;
            }
            StmUtils.retry();
        }
    }
}

