/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.util.HashSet;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_containsAllTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenCollectionNull_thenNullPointerException() {
        TransactionalArrayList list = new TransactionalArrayList();
        long version = this.stm.getVersion();
        try {
            list.containsAll(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenCollectionEmpty() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"a");
        long version = this.stm.getVersion();
        boolean result = list.containsAll(new LinkedList());
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenAllElementMatch() {
        HashSet<String> set = new HashSet<String>();
        set.add("a");
        set.add("b");
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"a");
        list.add((Object)"b");
        list.add((Object)"c");
        long version = this.stm.getVersion();
        boolean result = list.containsAll(set);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenNotAllElementsMatch() {
        HashSet<String> set = new HashSet<String>();
        set.add("a");
        set.add("d");
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"a");
        list.add((Object)"b");
        list.add((Object)"c");
        long version = this.stm.getVersion();
        boolean result = list.containsAll(set);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenNullElement_thenNoProblem() {
        LinkedList<String> set = new LinkedList<String>();
        set.add("a");
        set.add(null);
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"a");
        list.add(null);
        list.add((Object)"c");
        long version = this.stm.getVersion();
        boolean result = list.containsAll(set);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

