/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;

public class TransactionalArrayList_indexOfTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenElementNotAvailble_thenMinesOneReturned() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"1");
        list.add((Object)"2");
        list.add((Object)"3");
        long version = this.stm.getVersion();
        int result = list.indexOf((Object)"4");
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)-1L, (long)result);
    }

    @Test
    public void whenElementNull() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"1");
        list.add((Object)"2");
        list.add(null);
        list.add((Object)"4");
        long version = this.stm.getVersion();
        int result = list.indexOf(null);
        Assert.assertEquals((long)2L, (long)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenMultipleOccurrencesFirstElementReturned() {
        TransactionalArrayList list = new TransactionalArrayList();
        list.add((Object)"1");
        list.add((Object)"2");
        list.add((Object)"3");
        list.add((Object)"2");
        list.add((Object)"5");
        long version = this.stm.getVersion();
        int result = list.indexOf((Object)"2");
        Assert.assertEquals((long)1L, (long)result);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

